/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.srm.supplier.register.controller;

import com.elitesland.srm.sms.service.SmsService;
import com.elitesland.srm.supplier.register.service.SupplierRegisterService;
import com.elitesland.yst.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u767b\u8bb0\u6ce8\u518c"})
@ApiSupport(author="eric.hao", order=1)
@RestController
@RequestMapping(value={"/srm/supp"}, produces={"application/json"})
public class SupplierRegisterController {
    private static final Logger logger = LoggerFactory.getLogger(SupplierRegisterController.class);
    private final SupplierRegisterService registerService;
    private final SmsService smsService;

    @ApiOperation(value="\u4f9b\u5e94\u5546 - \u6ce8\u518c")
    @PostMapping(value={"/register"})
    public ApiResult<Long> registerSupplier(@RequestBody Object saveParam) {
        try {
            long suppId = this.registerService.registerSupp(saveParam);
            return ApiResult.ok((Object)suppId);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u9001\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/register/send/{mobile}"})
    public ApiResult<?> send(@PathVariable String mobile) {
        try {
            this.smsService.sendRegisterVerifyCode(mobile);
            return ApiResult.ok();
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public SupplierRegisterController(SupplierRegisterService registerService, SmsService smsService) {
        this.registerService = registerService;
        this.smsService = smsService;
    }
}

