package com.elitesland.yst.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租户类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/6
 */
public enum TenantType {

    /**
     * 租户类型
     */
    COMMON("普通租户"),
    OPERATION("运营机构");

    private final String description;

    TenantType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantType> VALUE_MAP = Arrays.stream(TenantType.values())
            .collect(Collectors.toMap(TenantType::name, t -> t, (t1, t2) -> t1));

    public static TenantType parse(String val) {
        if (val == null) {
            return null;
        }
        return VALUE_MAP.get(val);
    }
}
