/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.common.CloudtContextHolder;
import com.elitesland.yst.common.exception.filter.ExceptionFilter;
import com.elitesland.yst.common.exception.handler.CloudtExceptionProperties;
import com.elitesland.yst.common.property.EliteslandServiceProperties;
import com.elitesland.yst.common.property.IdProperties;
import com.elitesland.yst.common.property.LoginProperties;
import com.elitesland.yst.common.property.OAuth2Properties;
import com.elitesland.yst.common.property.SpecialAccountProperties;
import com.elitesland.yst.common.util.SpringContextHolder;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={IdProperties.class, CloudtExceptionProperties.class})
public class EliteslandConfig
implements InitializingBean {
    @Value(value="${spring.application.name:#{null}}")
    private String applicationName;
    private final CloudtExceptionProperties cloudtExceptionProperties;

    public EliteslandConfig(CloudtExceptionProperties cloudtExceptionProperties) {
        this.cloudtExceptionProperties = cloudtExceptionProperties;
    }

    @Bean
    @ConfigurationProperties(prefix="elitesland.oauth2")
    public OAuth2Properties oauth2Properties() {
        return new OAuth2Properties();
    }

    @Bean
    @ConfigurationProperties(prefix="elitesland.service")
    public EliteslandServiceProperties eliteslandServiceProperties() {
        return new EliteslandServiceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="elitesland.login")
    public LoginProperties loginProperties() {
        return new LoginProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="elitesland.special.account")
    public SpecialAccountProperties specialAccountProperties() {
        return new SpecialAccountProperties();
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    public ExceptionFilter exceptionFilter() {
        return new ExceptionFilter();
    }

    @Bean
    public FilterRegistrationBean registrationBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)this.exceptionFilter());
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(1);
        return bean;
    }

    public void afterPropertiesSet() throws Exception {
        this.initCloudtContextHolder();
    }

    private void initCloudtContextHolder() {
        String defaultExceptionMsg;
        String appName;
        if (StringUtils.hasText((String)this.applicationName)) {
            CloudtContextHolder.setAppCode(this.applicationName);
        }
        if (StringUtils.hasText((String)(appName = this.getAppName()))) {
            CloudtContextHolder.setAppName(appName);
        }
        if (StringUtils.hasText((String)(defaultExceptionMsg = this.getDefaultMsg()))) {
            CloudtContextHolder.setGlobalDefaultErrorMsg(defaultExceptionMsg);
        }
    }

    private String getAppName() {
        String appCode = CloudtContextHolder.getAppCode();
        if (StringUtils.hasText((String)appCode)) {
            for (CloudtExceptionProperties.AppInfo appInfo : this.cloudtExceptionProperties.getGlobal().getAppInfos()) {
                if (!CharSequenceUtil.equals((CharSequence)appCode, (CharSequence)appInfo.getAppCode())) continue;
                return appInfo.getAppName();
            }
        }
        return null;
    }

    private String getDefaultMsg() {
        String appName = CloudtContextHolder.getAppName();
        String format = this.cloudtExceptionProperties.getGlobal().getDefaultMsgFormat();
        return StrUtil.format((CharSequence)format, Map.of("appName", appName));
    }
}

