/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.property;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.elitesland.yst.common.exception.BadConfigurationException;
import com.elitesland.yst.common.property.CaptchaCodeEnum;
import com.elitesland.yst.common.property.CaptchaInfo;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Objects;

public class LoginProperties {
    private Boolean isSingleLogin;
    private Boolean isCaptchaNeeded;
    private CaptchaInfo captchaInfo;

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(this.captchaInfo)) {
            return null;
        }
        if (this.captchaInfo.getCodeType() == CaptchaCodeEnum.line || this.captchaInfo.getCodeType() == CaptchaCodeEnum.circle || this.captchaInfo.getCodeType() == CaptchaCodeEnum.shear) {
            switch (this.captchaInfo.getCodeType()) {
                case line: {
                    return CaptchaUtil.createLineCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
                case circle: {
                    return CaptchaUtil.createCircleCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
            }
            return CaptchaUtil.createShearCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
        }
        return null;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.captchaInfo)) {
            this.captchaInfo = new CaptchaInfo();
            if (Objects.isNull((Object)this.captchaInfo.getCodeType())) {
                this.captchaInfo.setCodeType(CaptchaCodeEnum.arithmetic);
            }
        }
        return this.switchCaptcha(this.captchaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha switchCaptcha(CaptchaInfo captchaInfo) {
        ArithmeticCaptcha captcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic: {
                    captcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese: {
                    captcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese_gif: {
                    captcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case gif: {
                    captcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case spec: {
                    captcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                default: {
                    throw new BadConfigurationException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\uff01\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b com.elitesland.yst.common.property.CaptchaCodeEnum ");
                }
            }
        }
        return captcha;
    }

    public Boolean getIsSingleLogin() {
        return this.isSingleLogin;
    }

    public Boolean getIsCaptchaNeeded() {
        return this.isCaptchaNeeded;
    }

    public CaptchaInfo getCaptchaInfo() {
        return this.captchaInfo;
    }

    public void setIsSingleLogin(Boolean isSingleLogin) {
        this.isSingleLogin = isSingleLogin;
    }

    public void setIsCaptchaNeeded(Boolean isCaptchaNeeded) {
        this.isCaptchaNeeded = isCaptchaNeeded;
    }

    public void setCaptchaInfo(CaptchaInfo captchaInfo) {
        this.captchaInfo = captchaInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginProperties)) {
            return false;
        }
        LoginProperties other = (LoginProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isSingleLogin = this.getIsSingleLogin();
        Boolean other$isSingleLogin = other.getIsSingleLogin();
        if (this$isSingleLogin == null ? other$isSingleLogin != null : !((Object)this$isSingleLogin).equals(other$isSingleLogin)) {
            return false;
        }
        Boolean this$isCaptchaNeeded = this.getIsCaptchaNeeded();
        Boolean other$isCaptchaNeeded = other.getIsCaptchaNeeded();
        if (this$isCaptchaNeeded == null ? other$isCaptchaNeeded != null : !((Object)this$isCaptchaNeeded).equals(other$isCaptchaNeeded)) {
            return false;
        }
        CaptchaInfo this$captchaInfo = this.getCaptchaInfo();
        CaptchaInfo other$captchaInfo = other.getCaptchaInfo();
        return !(this$captchaInfo == null ? other$captchaInfo != null : !((Object)this$captchaInfo).equals(other$captchaInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isSingleLogin = this.getIsSingleLogin();
        result = result * 59 + ($isSingleLogin == null ? 43 : ((Object)$isSingleLogin).hashCode());
        Boolean $isCaptchaNeeded = this.getIsCaptchaNeeded();
        result = result * 59 + ($isCaptchaNeeded == null ? 43 : ((Object)$isCaptchaNeeded).hashCode());
        CaptchaInfo $captchaInfo = this.getCaptchaInfo();
        result = result * 59 + ($captchaInfo == null ? 43 : ((Object)$captchaInfo).hashCode());
        return result;
    }

    public String toString() {
        return "LoginProperties(isSingleLogin=" + this.getIsSingleLogin() + ", isCaptchaNeeded=" + this.getIsCaptchaNeeded() + ", captchaInfo=" + this.getCaptchaInfo() + ")";
    }
}

