package com.elitesland.yst.common.base.param;

import com.elitesland.yst.common.constant.CommonConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 查询参数
 * @author Michael Li
 * @date 2018-11-08
 */
@Data
@ApiModel("查询参数对象")
public abstract class QueryParam implements Serializable {
    private static final long serialVersionUID = -3263921252635611410L;

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码,默认为1", example = "0")
    private Integer current = CommonConstant.DEFAULT_PAGE_INDEX;

    /**
     * 页大小
     */
    @ApiModelProperty(value = "页大小,默认为10", example = "10")
    private Integer size = CommonConstant.DEFAULT_PAGE_SIZE;

    /**
     * 搜索关键字
     */
    @ApiModelProperty(value = "搜索字符串", example = "")
    private String keyword;

    public Integer getCurrent() {
        return current > 0 ? current - 1 : 0;
    }

    public Integer getSize() {
        return size;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setCurrent(Integer current) {
        if (current == null || current < 0) {
            this.current = CommonConstant.DEFAULT_PAGE_INDEX;
        } else {
            this.current = current;
        }
    }

    public void setSize(Integer size) {
        if (size == null || size <= 0) {
            this.size = CommonConstant.DEFAULT_PAGE_SIZE;
        } else {
            this.size = size;
        }
    }

}
