package com.elitesland.yst.common.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * 缓存key生成器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/11
 */
@Component
public class CacheKeyGenerator {

    private final CloudtRedisProperties cloudtRedisProperties;

    private final RedisKeyPrefix redisKeyPrefixes;

    public CacheKeyGenerator(CloudtRedisProperties cloudtRedisProperties, ObjectProvider<RedisKeyPrefix> redisKeyPrefixes) {
        this.cloudtRedisProperties = cloudtRedisProperties;
        this.redisKeyPrefixes = redisKeyPrefixes.getIfAvailable();
    }

    @NonNull
    public String computeKey(@NonNull String key) {
        String pre = "";
        if (StringUtils.hasText(cloudtRedisProperties.getPrefix())) {
            pre = cloudtRedisProperties.getPrefix() + ":";
        }
        if (redisKeyPrefixes != null) {
            pre = pre + redisKeyPrefixes.getKeyPrefix() + ":";
        }

        if (key.indexOf(pre) == 0) {
            return key;
        }
        return pre + key;
    }
}
