package com.elitesland.yst.common.property;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.time.Duration;

/**
 * ID相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/14
 */
@Data
@ConfigurationProperties(prefix = "com.elitesland.cloudt.id")
public class IdProperties implements Serializable {
    private static final long serialVersionUID = -7557278001465397598L;

    private final Snowflake snowflake = new Snowflake();

    @Data
    public static class Snowflake implements Serializable {

        private static final long serialVersionUID = -4123202805590156989L;

        /**
         * dataCenter名称，默认应用名称
         */
        private String dataCenterName;

        /**
         * 是否自动生成
         */
        private Boolean genAuto = true;

        /**
         * dataCenter标识，genAuto=false时设置有效，必须大于0
         */
        private Long dataCenterId;

        /**
         * worker标识，genAuto=false时设置有效，必须大于0
         */
        private Long workerId;

        /**
         * 缓存key的前缀，genAuto=true时设置有效
         */
        private String cachePrefix = "cloudt_snowflake";

        /**
         * key的存活时间
         */
        private Duration alive = Duration.ofHours(12);

        /**
         * 心跳间隔，必须大于alive
         */
        private Duration heartBeat = Duration.ofHours(4);
    }
}
