package com.elitesland.yst.common.property;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.elitesland.yst.common.exception.BadConfigurationException;
import com.wf.captcha.*;
import com.wf.captcha.base.Captcha;
import lombok.Data;

import java.util.Objects;

/**
 * @author Michael Li
 * @date AC 2021-04-12:14:13
 */
@Data
public class LoginProperties {
    private Boolean isSingleLogin;

    private Boolean isCaptchaNeeded;

    private CaptchaInfo captchaInfo;

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(captchaInfo)) {
            return null;
        }

        if (captchaInfo.getCodeType() == CaptchaCodeEnum.line || captchaInfo.getCodeType() == CaptchaCodeEnum.circle || captchaInfo.getCodeType() == CaptchaCodeEnum.shear) {
            switch (captchaInfo.getCodeType()){
                case line:
                    return CaptchaUtil.createLineCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                case circle:
                    return CaptchaUtil.createCircleCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                default:
                    return CaptchaUtil.createShearCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
            }
        }

        return null;
    }

    /**
     * 获取验证码生产类
     *
     * @return /
     */
    public Captcha getCaptcha() {
        if (Objects.isNull(captchaInfo)) {
            captchaInfo = new CaptchaInfo();
            if (Objects.isNull(captchaInfo.getCodeType())) {
                captchaInfo.setCodeType(CaptchaCodeEnum.arithmetic);
            }
        }
        return switchCaptcha(captchaInfo);
    }

    /**
     * 依据配置信息生产验证码
     *
     * @param captchaInfo 验证码配置信息
     * @return /
     */
    private Captcha switchCaptcha(CaptchaInfo captchaInfo) {
        Captcha captcha;
        synchronized (this) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic:
                    // 算术类型 https://gitee.com/whvse/EasyCaptcha
                    captcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    // 几位数运算，默认是两位
                    captcha.setLen(captchaInfo.getLength());
                    break;
                case chinese:
                    captcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                case chinese_gif:
                    captcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                case gif:
                    captcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                case spec:
                    captcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                default:
                    throw new BadConfigurationException("验证码配置信息错误！！！正确配置查看 com.elitesland.yst.common.property.CaptchaCodeEnum ");
            }
        }
        return captcha;
    }
}
