package com.elitesland.yst.common.util;

import com.elitesland.yst.common.config.CacheKeyGenerator;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix = "redis.redlock-instance-config", name = "enabled", havingValue = "true")
public class RedLockUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private RedissonClient redissonClient0;
    private RedissonClient redissonClient1;
    private RedissonClient redissonClient2;

    @Autowired
    private CacheKeyGenerator keyGenerator;

    @Autowired
    public void setRedissonClient0(@Qualifier("redis_single_client0") RedissonClient redissonClient0) {
        this.redissonClient0 = redissonClient0;
    }

    @Autowired
    public void setRedissonClient1(@Qualifier("redis_single_client1") RedissonClient redissonClient1) {
        this.redissonClient1 = redissonClient1;
    }

    @Autowired
    public void setRedissonClient2(@Qualifier("redis_single_client2") RedissonClient redissonClient2) {
        this.redissonClient2 = redissonClient2;
    }

    public RedissonRedLock getRedLock(String lockName) {
        RLock lock0 = redissonClient0.getLock(keyGenerator.computeKey("RedLock:" + lockName));
        RLock lock1 = redissonClient1.getLock(keyGenerator.computeKey("RedLock:" + lockName));
        RLock lock2 = redissonClient2.getLock(keyGenerator.computeKey("RedLock:" + lockName));
        return new RedissonRedLock(lock0, lock1, lock2);
    }

    public boolean isHeldByThread(String lockName, Long threadId) {
        boolean status0 = redissonClient0.getLock(keyGenerator.computeKey("RedLock:" + lockName)).isHeldByThread(threadId);
        boolean status1 = redissonClient1.getLock(keyGenerator.computeKey("RedLock:" + lockName)).isHeldByThread(threadId);
        boolean status2 = redissonClient2.getLock(keyGenerator.computeKey("RedLock:" + lockName)).isHeldByThread(threadId);
        return status0 && status1 && status2;
    }
}
