package com.elitesland.yst.common.util;

import lombok.val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletRequest;
import java.io.BufferedReader;
import java.io.IOException;

/**
 * <pre>
 * 将请求的body的二进制内容转为字符串
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/16
 */
public class RequestUtil {

    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    private RequestUtil() {
    }

    public static String obtainBody(ServletRequest request) {
        BufferedReader br = null;
        val sb = new StringBuilder();
        try {
            br = request.getReader();
            String str;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        } catch (IOException e) {
            log.error("request body error");
        } finally {
            if (null != br) {
                try {
                    br.close();
                } catch (IOException e) {
                    log.error("request reader close error");
                }
            }
        }
        return sb.toString();
    }
}
