package com.elitesland.yst.common.util;

import lombok.val;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * <pre>
 * 整理异常中的堆栈信息，返回信息字符串
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/22
 */
public class ThrowableUtil {
    public static String getStackTrace(Throwable e) {
        val sw = new StringWriter();
        try (val pw = new PrintWriter(sw)) {
            e.printStackTrace(pw);
            return sw.toString();
        }
    }
}
