package org.hibernate.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * 功能说明:覆盖源码 支持继承
 *  具体源码参见 org.hibernate.annotations#ParamDef
 * </p>
 *
 * @author roman
 * @since 2022/2/23 5:22 PM
 */
@Target({})
@Retention(RUNTIME)
public @interface ParamDef {
    /**
     * The name of the parameter definition.
     */
    String name();

    /**
     * The type being defined,  Typically this is the fully-qualified name of the {@link org.hibernate.type.Type},
     * {@link org.hibernate.usertype.UserType} or {@link org.hibernate.usertype.CompositeUserType} implementation
     * class.
     */
    String type();
}
