/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base.param;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OrderItem
implements Serializable {
    private static final long serialVersionUID = 2195335725156215579L;
    private String column;
    private boolean asc = true;

    public static OrderItem asc(String column) {
        return OrderItem.build(column, true);
    }

    public static OrderItem desc(String column) {
        return OrderItem.build(column, false);
    }

    public static List<OrderItem> ascs(String ... columns) {
        return Arrays.stream(columns).map(OrderItem::asc).collect(Collectors.toList());
    }

    public static List<OrderItem> descs(String ... columns) {
        return Arrays.stream(columns).map(OrderItem::desc).collect(Collectors.toList());
    }

    private static OrderItem build(String column, boolean asc) {
        return new OrderItem(column, asc);
    }

    public String getColumn() {
        return this.column;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    public String toString() {
        return "OrderItem(column=" + this.getColumn() + ", asc=" + this.isAsc() + ")";
    }

    public OrderItem() {
    }

    public OrderItem(String column, boolean asc) {
        this.column = column;
        this.asc = asc;
    }
}

