/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import com.elitesland.yst.common.config.CacheKeyGenerator;
import com.elitesland.yst.common.config.CloudtRedisProperties;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.CacheConfigSupport;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@EnableConfigurationProperties(value={CloudtRedisProperties.class})
public class CacheRedisConfig
extends CacheConfigSupport {
    private final CloudtRedisProperties cloudtRedisProperties;
    private final CacheKeyGenerator cacheKeyGenerator;

    public CacheRedisConfig(CloudtRedisProperties cloudtRedisProperties, CacheKeyGenerator cacheKeyGenerator) {
        this.cloudtRedisProperties = cloudtRedisProperties;
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    @Bean
    @Primary
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().computePrefixWith(this.cacheKeyGenerator::computeKey));
    }

    @Bean
    public CacheManager redissonManager(RedissonClient redissonClient) {
        HashMap<CallSite, CacheConfig> configHashedMap = new HashMap<CallSite, CacheConfig>();
        configHashedMap.put((CallSite)((Object)(this.cloudtRedisProperties.getPrefix() + ":longCache")), new CacheConfig(180000L, 120000L));
        configHashedMap.put((CallSite)((Object)(this.cloudtRedisProperties.getPrefix() + ":shortCache")), new CacheConfig(60000L, 30000L));
        return new RedissonSpringCacheManager(redissonClient, configHashedMap);
    }
}

