/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import com.elitesland.yst.common.config.CloudtRedisProperties;
import com.elitesland.yst.common.config.RedisKeyPrefix;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CacheKeyGenerator {
    private final CloudtRedisProperties cloudtRedisProperties;
    private final RedisKeyPrefix redisKeyPrefixes;

    public CacheKeyGenerator(CloudtRedisProperties cloudtRedisProperties, ObjectProvider<RedisKeyPrefix> redisKeyPrefixes) {
        this.cloudtRedisProperties = cloudtRedisProperties;
        this.redisKeyPrefixes = (RedisKeyPrefix)redisKeyPrefixes.getIfAvailable();
    }

    @NonNull
    public String computeKey(@NonNull String key) {
        Object pre = "";
        if (StringUtils.hasText((String)this.cloudtRedisProperties.getPrefix())) {
            pre = this.cloudtRedisProperties.getPrefix() + ":";
        }
        if (this.redisKeyPrefixes != null) {
            pre = (String)pre + this.redisKeyPrefixes.getKeyPrefix() + ":";
        }
        if (key.indexOf((String)pre) == 0) {
            return key;
        }
        return (String)pre + key;
    }
}

