/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import com.elitesland.yst.common.util.SpringContextHolder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletResponse;

public final class HttpServletResponseUtil {
    private static String UTF8 = "UTF-8";
    private static String CONTENT_TYPE = "application/json";

    private HttpServletResponseUtil() {
        throw new AssertionError();
    }

    public static void printJSON(HttpServletResponse response, Object object) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)SpringContextHolder.getBean(LocalDateTimeSerializer.class));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)SpringContextHolder.getBean(LocalDateTimeDeserializer.class));
        mapper.registerModule((Module)javaTimeModule);
        response.setCharacterEncoding(UTF8);
        response.setContentType(CONTENT_TYPE);
        PrintWriter printWriter = response.getWriter();
        printWriter.write(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object));
        printWriter.flush();
        printWriter.close();
    }
}

