/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import com.elitesland.yst.common.config.CacheKeyGenerator;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedLockUtils {
    private static final String LOCK_NAME_PREFIX = "RedLock:";
    @Autowired
    private CacheKeyGenerator keyGenerator;
    @Autowired
    private ObjectProvider<RedissonClient> redissonClientObjectProvider;
    private List<RedissonClient> redissonClients;

    public RedissonRedLock getRedLock(String lockName) {
        if (this.getRedissonClients().isEmpty()) {
            throw new BusinessException("\u8bf7\u786e\u8ba4redisson\u662f\u5426\u5df2\u6b63\u786e\u914d\u7f6e");
        }
        RLock[] rLocks = (RLock[])this.getRedissonClients().stream().map(t -> t.getLock(this.keyGenerator.computeKey(LOCK_NAME_PREFIX + lockName))).toArray(RLock[]::new);
        return new RedissonRedLock(rLocks);
    }

    public boolean isHeldByThread(String lockName, Long threadId) {
        List statusList = this.getRedissonClients().stream().map(t -> t.getLock(this.keyGenerator.computeKey(LOCK_NAME_PREFIX + lockName)).isHeldByThread(threadId.longValue())).collect(Collectors.toList());
        for (Boolean st : statusList) {
            if (!Boolean.FALSE.equals(st)) continue;
            return false;
        }
        return true;
    }

    private List<RedissonClient> getRedissonClients() {
        if (this.redissonClients == null) {
            this.redissonClients = this.redissonClientObjectProvider.stream().collect(Collectors.toList());
        }
        return this.redissonClients;
    }
}

