/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.util.CollectionUtils;

@ApiModel(value="\u5206\u9875")
public class PagingVO<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -1683800405530086022L;
    @ApiModelProperty(value="\u603b\u884c\u6570")
    private Long total;
    @ApiModelProperty(value="\u6570\u636e\u5217\u8868")
    private List<T> records;

    public PagingVO() {
        this(0L, Collections.emptyList());
    }

    public PagingVO(long total, List<T> records) {
        this.total = total;
        this.records = records;
    }

    public static <T extends Serializable> PagingVO<T> empty() {
        return new PagingVO<T>();
    }

    public <R extends Serializable> PagingVO<R> map(@NotNull Function<T, R> mapper) {
        if (CollectionUtils.isEmpty(this.records)) {
            return new PagingVO<T>();
        }
        List result = this.records.stream().map(mapper).collect(Collectors.toList());
        return new PagingVO(this.total, result);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.records);
    }

    public String toString() {
        return "Paging{total=" + this.total + ", records=" + this.records + "}";
    }

    public static <T extends Serializable> PagingVOBuilder<T> builder() {
        return new PagingVOBuilder();
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public PagingVO<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    public PagingVO<T> setRecords(List<T> records) {
        this.records = records;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagingVO)) {
            return false;
        }
        PagingVO other = (PagingVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PagingVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public static class PagingVOBuilder<T extends Serializable> {
        private Long total;
        private List<T> records;

        PagingVOBuilder() {
        }

        public PagingVOBuilder<T> total(Long total) {
            this.total = total;
            return this;
        }

        public PagingVOBuilder<T> records(List<T> records) {
            this.records = records;
            return this;
        }

        public PagingVO<T> build() {
            return new PagingVO<T>(this.total, this.records);
        }

        public String toString() {
            return "PagingVO.PagingVOBuilder(total=" + this.total + ", records=" + this.records + ")";
        }
    }
}

