/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config.dynamic.datasource;

import com.elitesland.yst.common.config.dynamic.datasource.SpringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> dataSourceKey = ThreadLocal.withInitial(() -> "shardingDataSource");
    public static Map<Object, Object> dataSourcesMap = new ConcurrentHashMap<Object, Object>(10);

    protected Object determineCurrentLookupKey() {
        return dataSourceKey.get();
    }

    public static void setDataSource(String dataSource) {
        dataSourceKey.set(dataSource);
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)SpringUtils.getBean("dataSource"));
        dynamicDataSource.afterPropertiesSet();
    }

    public static String getDataSource() {
        return dataSourceKey.get();
    }

    public static void clear() {
        dataSourceKey.remove();
    }
}

