package com.elitesland.yst.security.common;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * 系统内置用户.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/14
 */
public enum InnerUserEnum {
    ADMIN("admin", Set.of(RoleWhiteListEnum.ADMIN));

    private final String username;
    private final Set<RoleWhiteListEnum> roles;

    InnerUserEnum(String username, Set<RoleWhiteListEnum> roles) {
        this.username = username;
        this.roles = Objects.requireNonNullElse(roles, Collections.emptySet());
    }

    public String getUsername() {
        return username;
    }

    public Set<RoleWhiteListEnum> getRoles() {
        return Collections.unmodifiableSet(roles);
    }
}
