package com.elitesland.yst.security.common;

import lombok.Getter;
import org.springframework.http.HttpMethod;

/**
 * 公共资源，权限白名单配置
 * @author Chris
 * @date 2021-07-09
 */
public enum PermissionWhiteListEnum {

    /**
     * 认证
     */
    AUTH_OAUTH_ALL("/oauth/**", null),
    AUTH_OAUTH2_ALL("/oauth2/**", null),
    SYS_CAPTCHA("/sec/captcha", null),
    AUTH_PUBLIC_KEY("/getPublicKey", null),

    /**
     * 前端获取当前登录人信息的接口，包括登录人信息和登录人所拥有的权限
     */
    USER_CURRENT("/sys/users/current", HttpMethod.GET),
    USER_CURRENT_MENU("/sys/users/current/menus", HttpMethod.GET),
    USER_CURRENT_MENU_PERM("/sys/users/current/menus/*", HttpMethod.GET),
    EMP_CURRENT("/org/emp/user/current", HttpMethod.GET),

//    /**
//     * 静态资源
//     */
//    STATIC_RESOURCES_HTML("/*.html", null),
//    STATIC_RESOURCES_HTML2("/**/*.html", null),
//    STATIC_RESOURCES_CSS("/**/*.css", null),
//    STATIC_RESOURCES_JS("/**/*.js", null),
//    STATIC_RESOURCES_WEBSOCKET("/webSocket/**", null),
//
//    /**
//     * swagger 文档
//     */
//    SWAGGER_UI("/swagger-ui.html", null),
//    SWAGGER_RESOURCES("/swagger-resources/**", null),
//    SWAGGER_WEBJAR("/webjars/**", null),
//    SWAGGER_DOCS("/*/api-docs", null),

    /**
     * 文件
     */
    FILE_AVATAR("/avatar/**", null),
    FILE("/file/**", null),

    /**
     * 阿里巴巴 druid
     */
    DRUID("/druid/**", null),

    OPTIONS_REQUEST("/**", HttpMethod.OPTIONS),
    ;

    @Getter
    private final String path;

    @Getter
    private final HttpMethod method;

    PermissionWhiteListEnum(String path, HttpMethod method) {
        this.path = path;
        this.method = method;
    }
}
