/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.security.entity;

import com.elitesland.yst.common.constant.TenantType;
import com.elitesland.yst.security.common.InnerUserEnum;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class GeneralUserDetails
implements UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = 414652772107486653L;
    @JsonIgnore
    private String password;
    private String username;
    private List<GrantedAuthority> authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    private SysUserDTO user;
    private String ip;
    private String browser;
    private String address;
    private LocalDateTime loginExpiredAt;
    private String token;
    private List<Long> selfBuIds;
    private SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO;
    private List<Long> grantedBuIds;
    private Object extendInfo;

    public GeneralUserDetails() {
    }

    public GeneralUserDetails(SysUserDTO sysUserDTO) {
        this.user = sysUserDTO;
    }

    public List<String> getRoleCodes() {
        if (this.user.getRoles() == null) {
            return Collections.emptyList();
        }
        return this.user.getRoles().stream().map(SysRoleVO::getCode).toList();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.user.getRoles() == null) {
            return Collections.emptyList();
        }
        return this.user.getRoles().stream().map(SysRoleVO::getCode).map(SimpleGrantedAuthority::new).toList();
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isAccountNonLocked() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isCredentialsNonExpired() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isEnabled() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public void eraseCredentials() {
        this.user.setPassword(null);
    }

    public Long getUserId() {
        return this.getUser().getId();
    }

    public Long getTenantId() {
        return this.getUser().getSysTenantVO() == null ? null : this.getUser().getSysTenantVO().getId();
    }

    public boolean isSystemAdmin() {
        return InnerUserEnum.ADMIN.getUsername().equals(this.getUsername());
    }

    public boolean isTenantAdmin() {
        return this.user.getSysTenantVO() != null && Objects.equals(this.getUserId(), this.user.getSysTenantVO().getSysUserId());
    }

    public boolean isTenantUser() {
        return this.user.getSysTenantVO() != null && !Objects.equals(this.getUserId(), this.user.getSysTenantVO().getSysUserId()) && this.user.getSysTenantVO().getType() != TenantType.OPERATION;
    }

    public boolean isOperation() {
        return this.user.getSysTenantVO() != null && this.user.getSysTenantVO().getType() == TenantType.OPERATION;
    }

    public boolean isCommonUser() {
        return this.user.getSysTenantVO() == null && !InnerUserEnum.ADMIN.getUsername().equals(this.getUsername());
    }

    public SysTenantDTO getTenant() {
        return this.user.getSysTenantVO();
    }

    public SysUserDTO getUser() {
        return this.user;
    }

    public String getIp() {
        return this.ip;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getAddress() {
        return this.address;
    }

    public LocalDateTime getLoginExpiredAt() {
        return this.loginExpiredAt;
    }

    public String getToken() {
        return this.token;
    }

    public List<Long> getSelfBuIds() {
        return this.selfBuIds;
    }

    public SecurityOrgUserEmpBuDTO getSecurityOrgUserEmpBuDTO() {
        return this.securityOrgUserEmpBuDTO;
    }

    public List<Long> getGrantedBuIds() {
        return this.grantedBuIds;
    }

    public Object getExtendInfo() {
        return this.extendInfo;
    }

    @JsonIgnore
    public GeneralUserDetails setPassword(String password) {
        this.password = password;
        return this;
    }

    public GeneralUserDetails setUsername(String username) {
        this.username = username;
        return this;
    }

    public GeneralUserDetails setAuthorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
        return this;
    }

    public GeneralUserDetails setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
        return this;
    }

    public GeneralUserDetails setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
        return this;
    }

    public GeneralUserDetails setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
        return this;
    }

    public GeneralUserDetails setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GeneralUserDetails setUser(SysUserDTO user) {
        this.user = user;
        return this;
    }

    public GeneralUserDetails setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public GeneralUserDetails setBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public GeneralUserDetails setAddress(String address) {
        this.address = address;
        return this;
    }

    public GeneralUserDetails setLoginExpiredAt(LocalDateTime loginExpiredAt) {
        this.loginExpiredAt = loginExpiredAt;
        return this;
    }

    public GeneralUserDetails setToken(String token) {
        this.token = token;
        return this;
    }

    public GeneralUserDetails setSelfBuIds(List<Long> selfBuIds) {
        this.selfBuIds = selfBuIds;
        return this;
    }

    public GeneralUserDetails setSecurityOrgUserEmpBuDTO(SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO) {
        this.securityOrgUserEmpBuDTO = securityOrgUserEmpBuDTO;
        return this;
    }

    public GeneralUserDetails setGrantedBuIds(List<Long> grantedBuIds) {
        this.grantedBuIds = grantedBuIds;
        return this;
    }

    public GeneralUserDetails setExtendInfo(Object extendInfo) {
        this.extendInfo = extendInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralUserDetails)) {
            return false;
        }
        GeneralUserDetails other = (GeneralUserDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAccountNonExpired() != other.isAccountNonExpired()) {
            return false;
        }
        if (this.isAccountNonLocked() != other.isAccountNonLocked()) {
            return false;
        }
        if (this.isCredentialsNonExpired() != other.isCredentialsNonExpired()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Collection<? extends GrantedAuthority> this$authorities = this.getAuthorities();
        Collection<? extends GrantedAuthority> other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        SysUserDTO this$user = this.getUser();
        SysUserDTO other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$browser = this.getBrowser();
        String other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        LocalDateTime this$loginExpiredAt = this.getLoginExpiredAt();
        LocalDateTime other$loginExpiredAt = other.getLoginExpiredAt();
        if (this$loginExpiredAt == null ? other$loginExpiredAt != null : !((Object)this$loginExpiredAt).equals(other$loginExpiredAt)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        List<Long> this$selfBuIds = this.getSelfBuIds();
        List<Long> other$selfBuIds = other.getSelfBuIds();
        if (this$selfBuIds == null ? other$selfBuIds != null : !((Object)this$selfBuIds).equals(other$selfBuIds)) {
            return false;
        }
        SecurityOrgUserEmpBuDTO this$securityOrgUserEmpBuDTO = this.getSecurityOrgUserEmpBuDTO();
        SecurityOrgUserEmpBuDTO other$securityOrgUserEmpBuDTO = other.getSecurityOrgUserEmpBuDTO();
        if (this$securityOrgUserEmpBuDTO == null ? other$securityOrgUserEmpBuDTO != null : !((Object)this$securityOrgUserEmpBuDTO).equals(other$securityOrgUserEmpBuDTO)) {
            return false;
        }
        List<Long> this$grantedBuIds = this.getGrantedBuIds();
        List<Long> other$grantedBuIds = other.getGrantedBuIds();
        if (this$grantedBuIds == null ? other$grantedBuIds != null : !((Object)this$grantedBuIds).equals(other$grantedBuIds)) {
            return false;
        }
        Object this$extendInfo = this.getExtendInfo();
        Object other$extendInfo = other.getExtendInfo();
        return !(this$extendInfo == null ? other$extendInfo != null : !this$extendInfo.equals(other$extendInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralUserDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAccountNonExpired() ? 79 : 97);
        result = result * 59 + (this.isAccountNonLocked() ? 79 : 97);
        result = result * 59 + (this.isCredentialsNonExpired() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Collection<? extends GrantedAuthority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        SysUserDTO $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        LocalDateTime $loginExpiredAt = this.getLoginExpiredAt();
        result = result * 59 + ($loginExpiredAt == null ? 43 : ((Object)$loginExpiredAt).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        List<Long> $selfBuIds = this.getSelfBuIds();
        result = result * 59 + ($selfBuIds == null ? 43 : ((Object)$selfBuIds).hashCode());
        SecurityOrgUserEmpBuDTO $securityOrgUserEmpBuDTO = this.getSecurityOrgUserEmpBuDTO();
        result = result * 59 + ($securityOrgUserEmpBuDTO == null ? 43 : ((Object)$securityOrgUserEmpBuDTO).hashCode());
        List<Long> $grantedBuIds = this.getGrantedBuIds();
        result = result * 59 + ($grantedBuIds == null ? 43 : ((Object)$grantedBuIds).hashCode());
        Object $extendInfo = this.getExtendInfo();
        result = result * 59 + ($extendInfo == null ? 43 : $extendInfo.hashCode());
        return result;
    }

    public String toString() {
        return "GeneralUserDetails(password=" + this.getPassword() + ", username=" + this.getUsername() + ", authorities=" + this.getAuthorities() + ", accountNonExpired=" + this.isAccountNonExpired() + ", accountNonLocked=" + this.isAccountNonLocked() + ", credentialsNonExpired=" + this.isCredentialsNonExpired() + ", enabled=" + this.isEnabled() + ", user=" + this.getUser() + ", ip=" + this.getIp() + ", browser=" + this.getBrowser() + ", address=" + this.getAddress() + ", loginExpiredAt=" + this.getLoginExpiredAt() + ", token=" + this.getToken() + ", selfBuIds=" + this.getSelfBuIds() + ", securityOrgUserEmpBuDTO=" + this.getSecurityOrgUserEmpBuDTO() + ", grantedBuIds=" + this.getGrantedBuIds() + ", extendInfo=" + this.getExtendInfo() + ")";
    }
}

