/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import com.google.common.base.Preconditions;
import io.seata.config.FileConfiguration;
import io.seata.core.context.RootContext;
import io.seata.rm.RMClient;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.tm.TMClient;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.base.seata.at.SeataTransactionHolder;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SeataATShardingTransactionManager
implements ShardingTransactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SeataATShardingTransactionManager.class);
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final String applicationId;
    private final String transactionServiceGroup;
    private final boolean enableSeata;

    public SeataATShardingTransactionManager() {
        String enabled = System.getProperty("seata.enabled", System.getenv("seata.enabled"));
        boolean bl = this.enableSeata = !StringUtils.hasText((String)enabled) || "true".equalsIgnoreCase(enabled);
        if (this.enableSeata) {
            LOG.info("\u542f\u7528sharding seata");
        }
        FileConfiguration configuration = new FileConfiguration("seata.conf");
        this.applicationId = configuration.getConfig("client.application.id");
        this.transactionServiceGroup = configuration.getConfig("client.transaction.service.group", "default");
    }

    public void init(DatabaseType databaseType, Collection<ResourceDataSource> resourceDataSources) {
        if (this.enableSeata) {
            this.initSeataRPCClient();
            for (ResourceDataSource each : resourceDataSources) {
                this.dataSourceMap.put(each.getOriginalName(), (DataSource)new DataSourceProxy(each.getDataSource()));
            }
        }
    }

    private void initSeataRPCClient() {
        Preconditions.checkNotNull((Object)this.applicationId, (Object)"please config application id within seata.conf file.");
        TMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
        RMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
    }

    public TransactionType getTransactionType() {
        return TransactionType.BASE;
    }

    public boolean isInTransaction() {
        Preconditions.checkState((boolean)this.enableSeata, (Object)"sharding seata-at transaction has been disabled.");
        return null != RootContext.getXID();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        Preconditions.checkState((boolean)this.enableSeata, (Object)"sharding seata-at transaction has been disabled.");
        return this.dataSourceMap.get(dataSourceName).getConnection();
    }

    public void begin() {
        Preconditions.checkState((boolean)this.enableSeata, (Object)"sharding seata-at transaction has been disabled.");
        GlobalTransaction globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
        globalTransaction.begin();
        SeataTransactionHolder.set((GlobalTransaction)globalTransaction);
    }

    public void commit() {
        Preconditions.checkState((boolean)this.enableSeata, (Object)"sharding seata-at transaction has been disabled.");
        try {
            if (SeataTransactionHolder.get() == null) {
                GlobalTransaction globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
                if (globalTransaction.getStatus() != null && globalTransaction.getStatus().getCode() == 1) {
                    SeataTransactionHolder.set((GlobalTransaction)globalTransaction);
                } else {
                    globalTransaction.begin();
                    SeataTransactionHolder.set((GlobalTransaction)globalTransaction);
                }
            }
            SeataTransactionHolder.get().commit();
        }
        finally {
            SeataTransactionHolder.clear();
            RootContext.unbind();
        }
    }

    public void rollback() {
        Preconditions.checkState((boolean)this.enableSeata, (Object)"sharding seata-at transaction has been disabled.");
        try {
            if (SeataTransactionHolder.get() == null) {
                GlobalTransaction globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
                if (globalTransaction.getStatus() != null && globalTransaction.getStatus().getCode() == 1) {
                    SeataTransactionHolder.set((GlobalTransaction)globalTransaction);
                } else {
                    globalTransaction.begin();
                    SeataTransactionHolder.set((GlobalTransaction)globalTransaction);
                }
            }
            SeataTransactionHolder.get().rollback();
        }
        finally {
            SeataTransactionHolder.clear();
            RootContext.unbind();
        }
    }

    public void close() {
        this.dataSourceMap.clear();
        SeataTransactionHolder.clear();
    }
}

