package com.elitesland.support.provider.item.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/26
 */
@Data
@ApiModel(value = "商品主表库存中心反参", description = "商品主表库存中心反参")
public class ItmItemPartDTO implements Serializable {

    private static final long serialVersionUID = 6681643271287656926L;

    /**
     * 品项id
     */
    @ApiModelProperty("品项id")
    private Long id;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brandName;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    private String packageSpec;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT")
    private String guaranteePeriodUnit;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 品项类型3 [UDC]ITM:ITEM_TYPE3 中燃指商品类型（大昌行指进口、国产）
     */
    @ApiModelProperty("品项类型3 [UDC]ITM:ITEM_TYPE3 中燃指商品类型（大昌行指进口、国产）")
    private String itemType3;

    /**
     * EN1 大昌行成本价
     */
    @ApiModelProperty("EN1 大昌行成本价")
    private BigDecimal en1;

    /**
     * 主计量单位
     */
    @ApiModelProperty("主计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;
}
