package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 商品新增校验重复参数
 *
 * @author chun.yan
 * @date 2022-05-30
 */
@Data
@ApiModel(value =" itm_item "  , description = "商品")
public class ItmItemCheckSaveParam implements Serializable{
private static final long serialVersionUID =3960580113867575891L;


	/**
	 * 商品编号(短项目号)
	 */
	@ApiModelProperty(value = "商品编号")
	private String itemCode;

	/**
	 * 商品编号2(长项目号)
	 */
	@ApiModelProperty(value = "商品编号2")
	private String itemCode2;

	/**
	 * 商品名称(品名)
	 */
	@ApiModelProperty(value = "商品名称")
	private String itemName;

	/**
	 * 规格，比如：食品净含量
	 */
	@ApiModelProperty(value = "规格，比如：食品净含量")
	private String spec;

	/**
	 * 商品规格
	 */
	@ApiModelProperty(value = "商品规格")
	private String itemAttr;

	/**
	 * 商品规格2（袋）
	 */
	@ApiModelProperty(value = "商品规格2")
	private String itemAttr2;

	/**
	 * 商品规格3（盒）
	 */
	@ApiModelProperty(value = "商品规格3")
	private String itemAttr3;

	/**
	 * 商品规格4（箱）
	 */
	@ApiModelProperty(value = "商品规格4")
	private String itemAttr4;

	/**
	 * 净重
	 */
	@ApiModelProperty(value = "净重")
	private Double netWeight;

	/**
	 * 最小起定量
	 */
	@ApiModelProperty(value = "最小起定量")
	private Double moq;

	/**
	 * 标准
	 */
	@ApiModelProperty(value = "标准")
	private String standard;

	/**
	 * 标准描述
	 */
	@ApiModelProperty(value = "标准描述")
	private String standardDesc;

	/**
	 * 标准排序
	 */
	@ApiModelProperty(value = "标准排序")
	private Integer standardSort;

	/**
	 * 材质
	 */
	@ApiModelProperty(value = "材质")
	private String material;

	/**
	 * 材质描述
	 */
	@ApiModelProperty(value = "材质描述")
	private String materialDesc;

	/**
	 * 材质排序
	 */
	@ApiModelProperty(value = "材质排序")
	private Integer materialSort;

	/**
	 * 直径
	 */
	@ApiModelProperty(value = "直径")
	private String diameter;

	/**
	 * 直径描述
	 */
	@ApiModelProperty(value = "直径描述")
	private String diameterDesc;

	/**
	 * 直径排序
	 */
	@ApiModelProperty(value = "直径排序")
	private Integer diameterSort;

	/**
	 * 长度
	 */
	@ApiModelProperty(value = "长度")
	private String lengths;

	/**
	 * 长度描述
	 */
	@ApiModelProperty(value = "长度描述")
	private String lengthsDesc;

	/**
	 * 长度排序
	 */
	@ApiModelProperty(value = "长度排序")
	private Integer lengthsSort;

	/**
	 * 牙别
	 */
	@ApiModelProperty(value = "牙别")
	private String tooth;

	/**
	 * 牙别描述
	 */
	@ApiModelProperty(value = "牙别描述")
	private String toothDesc;

	/**
	 * 牙别排序
	 */
	@ApiModelProperty(value = "牙别排序")
	private Integer toothSort;

	/**
	 * 表面处理
	 */
	@ApiModelProperty(value = "表面处理")
	private String surface;

	/**
	 * 表面处理描述
	 */
	@ApiModelProperty(value = "表面处理描述")
	private String surfaceDesc;

	/**
	 * 表面处理排序
	 */
	@ApiModelProperty(value = "表面处理排序")
	private Integer surfaceSort;

	/**
	 * 来源
	 */
	@ApiModelProperty(value = "来源")
	private String source;

}
