package com.elitesland.support.provider.item.service;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBomRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBomRpcParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Danny.Wang
 * @title ItmItemBomRpcService
 * @Date2023/2/28 16:58
 */
@Validated
@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + ItmItemBomRpcService.PATH)
public interface ItmItemBomRpcService {
    String PATH = "/itmItemBomRpc";

    /**
     * 获取商品bom信息
     * @param param
     * @return 商品bom信息
     */
    @PostMapping("/findItemBom")
    List<ItmItemBomRpcDTO> findItemBom(@RequestBody ItmItemBomRpcParam param);

}
