package com.elitesland.support.provider.item.service;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.vo.ItmItemCateDetailsDTO;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Validated
@Deprecated(forRemoval = true)
@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + ItmItemCateRpcService.PATH)
public interface ItmItemCateRpcService {

    String PATH = "/itmItemCateRpc";

    /**
     * 根据类别获取大中小类
     *
     */
    @PostMapping("/findItmItemCateByParam")
    List<ItmItemCateDetailsDTO> findItmItemCateByParam(@RequestBody List<Long> lists);

    /**
     * 根据物料类别码获取类别名称
     *
     * @param itemCateCode 类别码
     * @return 类别名称
     */
    @GetMapping("/findItemCateNameByItemCateCode")
    String findItemCateNameByItemCateCode(@RequestParam("itemCateCode") String itemCateCode);


    /**
     * 根据小类获取交期
     * @param c3Code
     * @return
     */
    @GetMapping("/getDemandDaysByC3Code")
    String getDemandDaysByC3Code(@RequestParam("c3Code") String c3Code);
}
