package com.elitesland.support.provider.item.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ryan.xu
 * @since 2022/09/28
 */
@ApiModel("品项单位转换率")
@Data
public class ConvertUomRatioDTO implements Serializable {
    private static final long serialVersionUID = 3276138851048412290L;
    
    @ApiModelProperty("源单位 -> 目标单位的转换率")
    private BigDecimal fromTo;

    @ApiModelProperty("目标单位 -> 源单位")
    private BigDecimal toFrom;

    @ApiModelProperty("源单位 -> 中间单位")
    private BigDecimal fromMid;

    @ApiModelProperty("目标单位 -> 中间单位")
    private BigDecimal toMid;
}
