package com.elitesland.support.provider.item.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品查询返回
 *
 * @author chun.yan
 * @date 2022-05-31
 */
@Data
@ApiModel(value = "商品查询返回", description = "商品查询返回")
public class ItmItemQueryDTO implements Serializable {

    private static final long serialVersionUID = -3353195443109194487L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品编号2（东明：IMAITM）
     */
    @ApiModelProperty("商品编号2（东明：IMAITM）")
    private String itemCode2;

    /**
     * 商品编号3（东明：IMLITM）
     */
    @ApiModelProperty("商品编号3（东明：IMLITM）")
    private String itemCode3;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;
    private String itemName2;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemAttr;

    /**
     * 商品规格2（东明：PACKSB-袋包装）
     */
    @ApiModelProperty("商品规格2（东明：PACKSB-袋包装）")
    private String itemAttr2;

    /**
     * 商品规格3（东明：PACKBOX-盒包装）
     */
    @ApiModelProperty("商品规格3（东明：PACKBOX-盒包装）")
    private String itemAttr3;

    /**
     * 商品规格4（东明：PACKBX-箱包装）
     */
    @ApiModelProperty("商品规格4（东明：PACKBX-箱包装）")
    private String itemAttr4;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 库存计量单位
     */
    @ApiModelProperty("库存计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String storeUom;
    private String storeUomName;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    /**
     * 最小起订量
     */
    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    /**
     * 标准
     */
    @ApiModelProperty("标准")
    private String standard;

    /**
     * 标准描述
     */
    @ApiModelProperty("标准描述")
    private String standardDesc;

    /**
     * 标准描述
     */
    @ApiModelProperty("标准描述")
    private Integer standardSort;

    /**
     * 材质
     */
    @ApiModelProperty("材质")
    private String material;

    /**
     * 材质描述
     */
    @ApiModelProperty("材质描述")
    private String materialDesc;

    /**
     * 材质描述
     */
    @ApiModelProperty("材质描述")
    private Integer materialSort;

    /**
     * 直径
     */
    @ApiModelProperty("直径")
    private String diameter;

    /**
     * 直径描述
     */
    @ApiModelProperty("直径描述")
    private String diameterDesc;

    /**
     * 直径描述
     */
    @ApiModelProperty("直径描述")
    private Integer diameterSort;

    /**
     * 长度
     */
    @ApiModelProperty("长度")
    private String lengths;

    /**
     * 长度描述
     */
    @ApiModelProperty("长度描述")
    private String lengthsDesc;

    /**
     * 长度描述
     */
    @ApiModelProperty("长度描述")
    private Integer lengthsSort;

    /**
     * 牙别
     */
    @ApiModelProperty("牙别")
    private String tooth;

    /**
     * 牙别描述
     */
    @ApiModelProperty("牙别描述")
    private String toothDesc;

    /**
     * 牙别描述
     */
    @ApiModelProperty("牙别描述")
    private Integer toothSort;

    /**
     * 表面处理
     */
    @ApiModelProperty("表面处理")
    private String surface;

    /**
     * 表面处理
     */
    @ApiModelProperty("表面处理描述")
    private String surfaceDesc;

    /**
     * 表面处理
     */
    @ApiModelProperty("表面处理描述")
    private Integer surfaceSort;

    /**
     * 强度
     */
    @ApiModelProperty("强度处理")
    private String strength;

    /**
     * 强度处理
     */
    @ApiModelProperty("强度描述")
    private String strengthDesc;

    /**
     * 强度处理
     */
    @ApiModelProperty("强度描述")
    private Integer strengthSort;

    /**
     * 来源
     */
    @ApiModelProperty("来源")
    private String source;

    /**
     * SPU ID
     */
    @ApiModelProperty("SPU ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    /**
     * SPU编码
     */
    @ApiModelProperty("SPU编码")
    private String spuCode;

    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 分类ID
     */
    @ApiModelProperty("分类ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    /**
     * 商品状态
     */
    @ApiModelProperty("商品状态")
    @SysCode(sys = "yst-supp", mod = "AUDIT_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;


    @ApiModelProperty(value = "等级")
    private String itemLevel;

    @ApiModelProperty(value = "等级描述")
    private String itemLevelDesc;

    @ApiModelProperty(value = "等级排序")
    private Integer itemLevelSort;

    @ApiModelProperty(value = "组合垫圈类型")
    private String washerType;

    @ApiModelProperty(value = "组合垫圈类型描述")
    private String washerTypeDesc;

    @ApiModelProperty(value = "组合垫圈类型排序")
    private Integer washerTypeSort;

    @ApiModelProperty(value = "种类")
    private String kind;

    @ApiModelProperty(value = "种类描述")
    private String kindDesc;

    @ApiModelProperty(value = "种类排序")
    private Integer kindSort;

    @ApiModelProperty(value = "用途")
    private String purpose;

    @ApiModelProperty(value = "用途描述")
    private String purposeDesc;

    @ApiModelProperty(value = "用途排序")
    private Integer purposeSort;

    @ApiModelProperty(value = "牙长")
    private String toothLength;

    @ApiModelProperty(value = "牙长描述")
    private String toothLengthDesc;

    @ApiModelProperty(value = "牙长排序")
    private Integer toothLengthSort;

    @ApiModelProperty(value = "牙型")
    private String toothShape;

    @ApiModelProperty(value = "牙型描述")
    private String toothShapeDesc;

    @ApiModelProperty(value = "牙型排序")
    private Integer toothShapeSort;

    @ApiModelProperty(value = "型状")
    private String shape;

    @ApiModelProperty(value = "型状描述")
    private String shapeDesc;

    @ApiModelProperty(value = "型状排序")
    private Integer shapeSort;

    @ApiModelProperty(value = "尾状")
    private String caudate;

    @ApiModelProperty(value = "尾状描述")
    private String caudateDesc;

    @ApiModelProperty(value = "尾状排序")
    private Integer caudateSort;

    @ApiModelProperty(value = "外径")
    private String outerDiameter;

    @ApiModelProperty(value = "外径描述")
    private String outerDiameterDesc;

    @ApiModelProperty(value = "外径排序")
    private Integer outerDiameterSort;

    @ApiModelProperty(value = "头型")
    private String headShape;

    @ApiModelProperty(value = "头型描述")
    private String headShapeDesc;

    @ApiModelProperty(value = "头型排序")
    private Integer headShapeSort;

    @ApiModelProperty(value = "螺纹")
    private String whorl;

    @ApiModelProperty(value = "螺纹描述")
    private String whorlDesc;

    @ApiModelProperty(value = "螺纹排序")
    private Integer whorlSort;

    @ApiModelProperty(value = "厚度")
    private String thickness;

    @ApiModelProperty(value = "厚度描述")
    private String thicknessDesc;

    @ApiModelProperty(value = "厚度排序")
    private Integer thicknessSort;

    @ApiModelProperty(value = "杆状")
    private String rhabditiform;

    @ApiModelProperty(value = "杆状描述")
    private String rhabditiformDesc;

    @ApiModelProperty(value = "杆状排序")
    private Integer rhabditiformSort;

    @ApiModelProperty(value = "防松处理")
    private String antiLoose;

    @ApiModelProperty(value = "防松处理描述")
    private String antiLooseDesc;

    @ApiModelProperty(value = "防松处理排序")
    private Integer antiLooseSort;

    @ApiModelProperty(value = "尺寸等级")
    private String sizeLevel;

    @ApiModelProperty(value = "尺寸等级描述")
    private String sizeLevelDesc;

    @ApiModelProperty(value = "尺寸等级排序")
    private Integer sizeLevelSort;

    @ApiModelProperty(value = "槽型")
    private String grooveShape;

    @ApiModelProperty(value = "槽型描述")
    private String grooveShapeDesc;

    @ApiModelProperty(value = "槽型排序")
    private Integer grooveShapeSort;

    @ApiModelProperty(value = "内径")
    private String innerDiameter;

    @ApiModelProperty(value = "内径描述")
    private String innerDiameterDesc;

    @ApiModelProperty(value = "内径排序")
    private Integer innerDiameterSort;

    @ApiModelProperty(value = "加工方式")
    private String processingMethod;

    @ApiModelProperty(value = "加工方式描述")
    private String processingMethodDesc;

    @ApiModelProperty(value = "加工方式排序")
    private Integer processingMethodSort;

    @ApiModelProperty(value = "适用行业")
    private String suitIndustry;

    @ApiModelProperty(value = "适用行业描述")
    private String suitIndustryDesc;

    @ApiModelProperty(value = "适用行业排序")
    private Integer suitIndustrySort;


}
