package com.elitesland.support.provider.item.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 商品SPU查询
 * @author chun.yan
 * @date 2022-05-31
 */
@Data
@ApiModel(value = "商品SPU查询反参", description = "商品SPU查询反参")
public class ItmItemSpuQueryDTO implements Serializable {

    private static final long serialVersionUID = 8946060366505421472L;
    /**
     * ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * SPU编码
     */
    @ApiModelProperty("SPU编码")
    private String spuCode;

    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    @SysCode(sys = "yst-supp", mod = "ITEM_SPU_BRAND")
    private String brand;
    private String brandName;

    /**
     * 计量单位
     */
    @ApiModelProperty("计量单位")
    @SysCode(sys = "yst-supp", mod = "ITEM_SPU_UNIT")
    private String unit;
    private String unitName;

    /**
     * 销售单位
     */
    @ApiModelProperty("销售单位")
    @SysCode(sys = "yst-supp", mod = "ITEM_SPU_UNIT")
    private String saleUnit;
    private String saleUnitName;

    /**
     * 分类ID
     */
    @ApiModelProperty("分类ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    /**
     * spu详情
     */
    @ApiModelProperty(value = "spu详情")
    private String spuDetailInfo;

    /**
     * 图片名称
     */
    @ApiModelProperty(value = "图片名称")
    private String spuFileName;

    /**
     * 图片编码
     */
    @ApiModelProperty(value = "图片编码")
    private String spuFileCode;

    /**
     * SPU状态
     */
    @ApiModelProperty("SPU状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_AUDIT_STATUS")
    private String spuStatus;
    private String spuStatusName;

}
