package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 功能说明 给前端:demo表
 *
 * @author meng
 * @date 2022-04-29 13:25:22
 */
@Data
@ApiModel(value = " yst_serviceset ", description = "采购比例设置表")
public class YstServicesetDTO implements Serializable {
    private static final long serialVersionUID = 5338089693684488716L;

    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 租户ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;

    /**
     * 备注
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    /**
     * 记录创建者
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建者")
    private String creator;

    /**
     * 记录创建时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    /**
     * 记录最后更新者
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除，0：未删除，1：已删除
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    /**
     * 锁版本
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    /**
     * sec_bu_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_bu_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    /**
     * sec_user_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_user_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    /**
     * sec_ou_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_ou_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 公司ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 流程实例ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "流程实例ID")
    private String procInstId;

    /**
     * 流程实例状态
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "流程实例状态")
    private String procInstStatus;

    /**
     * 提交时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    /**
     * 审批通过时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 超量比例
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "超量比例")
    private Double moreProportion;

    /**
     * 欠量比例
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "欠量比例")
    private Double lessProportion;

    /**
     * 比例
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "比例")
    private Double itemProportion;

    /**
     * 按照供应商汇总
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "按照供应商汇总")
    private String suppSummary;

    /**
     * 按照时间汇总
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "按照时间汇总")
    private String timeSummary;

    @ApiModelProperty(value = "按照采购时间汇总")
    private String purtimeSummary;

    @ApiModelProperty(value = "是否是全部公司默认：1是，0否")
    private Boolean allOu;
}
