package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgBuDetailsRpcDTO;
import com.elitesland.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.support.provider.org.param.OrgBuRpcSaveParam;
import com.elitesland.support.provider.org.param.OrgBuRpcSaveResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@Validated
@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + OrgBuRpcService.PATH)
public interface OrgBuRpcService {
    String PATH = "/orgBuRpc";

    /**
     * 通过userId获取所属即下级所有组织id
     * 组织第一条数据为当前用户所属组织ID，之后的数据为拥有权限的组织ID
     *
     * @param userId 用户ID
     * @return 组织ID列表
     */
    @GetMapping("/buListByUserId/{userId}")
    List<Long> findBuIdsByUserId(@PathVariable("userId") Long userId);

    /**
     * 通过username获取所属即下级所有组织id
     * 组织第一条数据为当前用户所属组织ID，之后的数据为拥有权限的组织ID
     *
     * @param username 用户名
     * @return 组织ID列表
     */
    @GetMapping("//buListByUserName/{userName}")
    List<Long> findBuIdsByUsername(@PathVariable("userName") String username);

    /**
     * 新增/编辑 组织信息
     * 接口会附带创建地址薄信息，请不要额外调用地址薄创建接口，否则会出现两个地址薄信息
     *
     * @param param 保存参数
     * @return 保存结果
     */
    @PostMapping("/BuInfo")
    ApiResult<OrgBuRpcSaveResult> orgBuRpcSaveOrUpdate(@RequestBody OrgBuRpcSaveParam param);

    /**
     * 根据组织ID获取组织详情信息
     *
     * @param id  组织ID
     * @return 组织详情DTO
     */

    @PostMapping("/BuDetail")
    ApiResult<OrgBuDetailsRpcDTO> findDetailDtoById(@RequestParam(name = "id") Long id);

    /**
     * 获取组织信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     *
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     *
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/BuList")
    @Validated
    List<OrgBuRpcDTO> findBuDtoByParam(@RequestBody OrgBuRpcDtoParam param);
}
