package com.elitesland.support.provider.item.param;

import com.elitesland.support.provider.item.dto.ItmItemPicDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author : chun.yan
 * @Date : 2022-05-30
 */
@Data
public class ItmItemSpuSaveParam implements Serializable {

    private static final long serialVersionUID = -6436985786269312000L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * SPU编码
     */
    @ApiModelProperty(value = "SPU编码")
//    @NotNull(message = "产品编码不能为空")
    private String spuCode;

    /**
     * SPU名称
     */
    @ApiModelProperty(value = "SPU名称")
//    @NotNull(message = "产品名称不能为空")
    private String spuName;

    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌")
//    @NotNull(message = "品牌不能为空")
    private String brand;

    /**
     * 计量单位
     */
    @ApiModelProperty(value = "计量单位")
//    @NotNull(message = "计量单位不能为空")
    private String unit;

    /**
     * 销售单位
     */
    @ApiModelProperty(value = "销售单位")
    private String saleUnit;

    /**
     * 分类ID
     */
    @ApiModelProperty(value = "分类ID")
//    @NotNull(message = "产品分类ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    /**
     * 商品信息列表
     */
    @ApiModelProperty(value = "商品信息列表")
    private List<ItmItemSaveParam> itemSaveParamList;

    /**
     * spu详情
     */
    @ApiModelProperty(value = "spu详情")
    private String spuDetailInfo;

    /**
     * spu图片名称
     */
    @ApiModelProperty(value = "spu图片名称")
    private String spuFileName;

    /**
     * spu图片fileCode
     */
    @ApiModelProperty(value = "spu图片fileCode")
    private String spuFileCode;

    /**
     * spu状态
     */
    @ApiModelProperty(value = "spu状态")
    private String spuStatus;

    /**
     * 图片列表
     */
    @ApiModelProperty("图片列表")
    private List<ItmItemPicDTO> spuPicList;

    /**
     * 关联分类ID
     */
    @ApiModelProperty("关联分类ID")
    private List<Long> relevanceCatIdList;

}
