package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/26
 */
@Data
@ApiModel(value = "商品主表反参", description = "商品主表反参")
public class ItmItemDTO implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 税收分类码 [UDC]ITM:TAX_TYPE
     */
    @ApiModelProperty("税收分类码 [UDC]ITM:TAX_TYPE")
    @SysCode(sys = "yst-supp", mod = "TAX_TYPE")
    String taxType;
    String taxTypeName;

    /**
     * 包装方式 [UDC]ITM:PACKAGE_METHOD
     */
    @ApiModelProperty("包装方式 [UDC]ITM:PACKAGE_METHOD")
    @SysCode(sys = "yst-supp", mod = "PACKAGE_METHOD")
    String packageMethod;
    String packageMethodName;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    String itemCode;

    /**
     * 第二编号
     */
    @ApiModelProperty("第二编号")
    String itemCode2;

    /**
     * 第三编号
     */
    @ApiModelProperty("第三编号")
    String itemCode3;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    String itemName;

    /**
     * 第二名称
     */
    @ApiModelProperty("第二名称")
    String itemName2;

    /**
     * 第三名称
     */
    @ApiModelProperty("第三名称")
    String itemName3;

    /**
     * 品项类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    String itemType;
    String itemTypeName;

    /**
     * 品项类型2 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("品项类型2 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    String itemType2;
    String itemType2Name;

    /**
     * 品项类型3 [UDC]ITM:ITEM_TYPE3
     */
    @ApiModelProperty("品项类型3 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    String itemType3;
    String itemType3Name;

    /**
     * 品项类型4 [UDC]INV:TRANSPORT_TEMP
     */
    @ApiModelProperty("品项类型4 [UDC]INV:TRANSPORT_TEMP")
    @SysCode(sys = "yst-supp", mod = "TRANSPORT_TEMP")
    String itemType4;
    String itemType4Name;

    /**
     * 品项类型5
     */
    @ApiModelProperty("品项类型5")
    String itemType5;

    /**
     * 品项组 [UDC]ITM:ITEM_GROUP
     */
    @ApiModelProperty("品项组 [UDC]ITM:ITEM_GROUP")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP")
    String itemGroup;
    String itemGroupName;

    /**
     * 品项简称
     */
    @ApiModelProperty("品项简称")
    String itemAbbr;

    /**
     * 品项标题 简短介绍
     */
    @ApiModelProperty("品项标题 简短介绍")
    String itemTitle;

    /**
     * 品项描述 文描，可含有格式，包含导航段落信息
     */
    @ApiModelProperty("品项描述 文描，可含有格式，包含导航段落信息")
    String itemDesc;

    /**
     * 副标题 如京东有
     */
    @ApiModelProperty("副标题 如京东有")
    String subTitle;

    /**
     * 助记码
     */
    @ApiModelProperty("助记码")
    String memCode;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    String barCode;

    /**
     * 条码2
     */
    @ApiModelProperty("条码2")
    String barCode2;

    /**
     * 拼音
     */
    @ApiModelProperty("拼音")
    String pinyin;

    /**
     * 拼音简称
     */
    @ApiModelProperty("拼音简称")
    String pinyinSh;

    /**
     * 促销信息
     */
    @ApiModelProperty("促销信息")
    String promotionInfo;

    /**
     * 关键词
     */
    @ApiModelProperty("关键词")
    String keywords;

    /**
     * 标记 如热销、推荐、正品、新品。可多选
     */
    @ApiModelProperty("标记 如热销、推荐、正品、新品。可多选")
    String marks;

    /**
     * 品项状态
     */
    @ApiModelProperty("品项状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    String itemStatus;
    String itemStatusName;

    /**
     * 品项状态2
     */
    @ApiModelProperty("品项状态2")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    String itemStatus2;
    String itemStatus2Name;

    /**
     * 品项状态3
     */
    @ApiModelProperty("品项状态3")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    String itemStatus3;
    String itemStatus3Name;

    /**
     * 上架状态
     */
    @ApiModelProperty("上架状态")
    String listingStatus;

    /**
     * 大类编号 使用COM_C1表
     */
    @ApiModelProperty("大类编号 使用COM_C1表")
    String c1Code;

    /**
     * 中类编号 使用COM_C2表
     */
    @ApiModelProperty("中类编号 使用COM_C2表")
    String c2Code;

    /**
     * 小类编号
     */
    @ApiModelProperty("小类编号")
    String c3Code;

    /**
     * 主计量单位
     */
    @ApiModelProperty("主计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 计量单位2
     */
    @ApiModelProperty("计量单位2")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 计量单位3
     */
    @ApiModelProperty("计量单位3")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 计量单位4
     */
    @ApiModelProperty("计量单位4")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 默认销售单位
     */
    @ApiModelProperty("默认销售单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 默认采购单位
     */
    @ApiModelProperty("默认采购单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    Float grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    Float netWeight;

    /**
     * 重量单位 克还是吨
     */
    @ApiModelProperty("重量单位 克还是吨")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightUom;
    private String weightUomName;

    /**
     * 重量对应的品项单位 支还是千支
     */
    @ApiModelProperty("重量对应的品项单位 支还是千支")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightItemuom;
    private String weightItemuomName;

    /**
     * 毛重2
     */
    @ApiModelProperty("毛重2")
    Float grossWeight2;

    /**
     * 净重2
     */
    @ApiModelProperty("净重2")
    Float netWeight2;

    /**
     * 重量2单位 克还是吨
     */
    @ApiModelProperty("重量2单位 克还是吨")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightUom2;
    private String weightUom2Name;

    /**
     * 重量2对应的品项单位 箱或包等包装单位
     */
    @ApiModelProperty("重量2对应的品项单位 箱或包等包装单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightItemuom2;
    private String weightItemuom2Name;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    Float volume;

    /**
     * 最小起订量
     */
    @ApiModelProperty("最小起订量")
    Float moq;

    /**
     * 安全库存
     */
    @ApiModelProperty("安全库存")
    Float safeQty;

    /**
     * 最大库存量
     */
    @ApiModelProperty("最大库存量")
    Float maxQty;

    /**
     * 最大要货量
     */
    @ApiModelProperty("最大要货量")
    Float maxOrderQty;

    /**
     * 存储类型
     */
    @ApiModelProperty("存储类型")
    String packageType;

    /**
     * 整包装数量
     */
    @ApiModelProperty("整包装数量")
    Float packageQty;

    /**
     * 批量
     */
    @ApiModelProperty("批量")
    Float batchQty;

    /**
     * 要货容差率
     */
    @ApiModelProperty("要货容差率")
    Float orderTolerance;

    /**
     * 默认售价
     */
    @ApiModelProperty("默认售价")
    Float salePrice;

    /**
     * 销售价格组
     */
    @ApiModelProperty("销售价格组")
    String salePriceGroup;

    /**
     * 默认采购价
     */
    @ApiModelProperty("默认采购价")
    Float purcPrice;

    /**
     * 采购价格组
     */
    @ApiModelProperty("采购价格组")
    String purcPriceGroup;

    /**
     * 价格
     */
    @ApiModelProperty("价格")
    Float itemPrice;

    /**
     * 调价周期
     */
    @ApiModelProperty("调价周期")
    String pricePeriod;

    /**
     * 档口ID
     */
    @ApiModelProperty("档口ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long stallId;

    /**
     * 档口编号
     */
    @ApiModelProperty("档口编号")
    String stallCode;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    String packageSpec;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    String spec;

    /**
     * 材质
     */
    @ApiModelProperty("材质")
    String material;

    /**
     * 等级
     */
    @ApiModelProperty("等级")
    String grade;

    /**
     * 标准
     */
    @ApiModelProperty("标准")
    String standard;

    /**
     * 表面处理
     */
    @ApiModelProperty("表面处理")
    String surface;

    /**
     * 产地
     */
    @ApiModelProperty("产地")
    String origin;

    /**
     * 印记
     */
    @ApiModelProperty("印记")
    String stamp;

    /**
     * 长度
     */
    @ApiModelProperty("长度")
    String itemLen;

    /**
     * 直径
     */
    @ApiModelProperty("直径")
    String dimension;

    /**
     * 强度
     */
    @ApiModelProperty("强度")
    String strength;

    /**
     * 牙别
     */
    @ApiModelProperty("牙别")
    String teeth;

    /**
     * 税码 进项VAT
     */
    @ApiModelProperty("税码 进项VAT")
    String taxCode;

    /**
     * 税率索引 进项
     */
    @ApiModelProperty("税率索引 进项")
    @SysCode(sys = "yst-supp", mod = "TAX_RATE_INDEX")
    String taxRateIndex;
    String taxRateIndexName;

    /**
     * 税率编号 进项VAT
     */
    @ApiModelProperty("税率编号 进项VAT")
    String taxRateNo;

    /**
     * 税率 进项VAT
     */
    @ApiModelProperty("税率 进项VAT")
    Float taxRate;

    /**
     * 税码 销项VAT
     */
    @ApiModelProperty("税码 销项VAT")
    String taxCodeOut;

    /**
     * 税率编号 销项VAT
     */
    @ApiModelProperty("税率编号 销项VAT")
    String taxRateNoout;

    /**
     * 税率 销项VAT
     */
    @ApiModelProperty("税率 销项VAT")
    Float taxRateOut;

    /**
     * 税率索引 销项
     */
    @ApiModelProperty("税率索引 销项")
    @SysCode(sys = "yst-supp", mod = "TAX_RATE_INDEX")
    String taxRateIndexout;
    String taxRateIndexoutName;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    Float taxRateTariff;

    /**
     * 采购员ID
     */
    @ApiModelProperty("采购员ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long purchaserId;

    /**
     * 销售员ID
     */
    @ApiModelProperty("销售员ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long salesmanId;

    /**
     * 采购员姓名
     */
    @ApiModelProperty("采购员姓名")
    String purchaserName;

    /**
     * 销售员姓名
     */
    @ApiModelProperty("销售员姓名")
    String salesmanName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long suppId;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    String suppName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    String brandName;

    /**
     * 品牌2
     */
    @ApiModelProperty("品牌2")
    String brand2;

    /**
     * 品牌2名称
     */
    @ApiModelProperty("品牌2名称")
    String brand2Name;

    /**
     * 代理商
     */
    @ApiModelProperty("代理商")
    String agency;

    /**
     * 要求部门ID
     */
    @ApiModelProperty("要求部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long reqDeptId;

    /**
     * 要求原因
     */
    @ApiModelProperty("要求原因")
    String reqReason;

    /**
     * 用途描述
     */
    @ApiModelProperty("用途描述")
    String usageDesc;

    /**
     * 转正日期
     */
    @ApiModelProperty("转正日期")
    LocalDateTime approveDate;

    /**
     * 财务总账类别 [UDC]ITM:FIN_GL_TYPE
     */
    @ApiModelProperty("财务总账类别 [UDC]ITM:FIN_GL_TYPE")
    @SysCode(sys = "yst-supp", mod = "FIN_GL_TYPE")
    String finGlType;
    String finGlTypeName;

    /**
     * 成本计价方式 FIFO/加权平均
     */
    @ApiModelProperty("成本计价方式 FIFO/加权平均")
    String costType;

    /**
     * 成本级 [UDC]ITM:COST_LEVEL
     */
    @ApiModelProperty("成本级 [UDC]ITM:COST_LEVEL")
    @SysCode(sys = "yst-supp", mod = "COST_LEVEL")
    String costLeve;
    String costLeveName;

    /**
     * 采购类型 按计划采购/日常请购
     */
    @ApiModelProperty("采购类型 按计划采购/日常请购")
    String purchaseType;

    /**
     * 采购类型2 集采/地产
     */
    @ApiModelProperty("采购类型2 集采/地产")
    String purchaseType2;

    /**
     * 配货类型 总部强配/门店要货
     */
    @ApiModelProperty("配货类型 总部强配/门店要货")
    String allocType;

    /**
     * 配送类型 总部配送/供应商配送
     */
    @ApiModelProperty("配送类型 总部配送/供应商配送")
    String deliverType;

    /**
     * 订货周期
     */
    @ApiModelProperty("订货周期")
    String orderPeriod;

    /**
     * 库存ABC类型
     */
    @ApiModelProperty("库存ABC类型")
    String abcType;

    /**
     * 库存出库方式 FIFO/LIFO/批内FIFO/批内FILO
     */
    @ApiModelProperty("库存出库方式 FIFO/LIFO/批内FIFO/批内FILO")
    String storeOutMethod;

    /**
     * 库存管理类型 [UDC]ITM:STORE_TYPE
     */
    @ApiModelProperty("库存管理类型 [UDC]ITM:STORE_TYPE")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE")
    String storeType;
    String storeTypeName;

    /**
     * 存储方式 [UDC]ITM:STORE_MODE
     */
    @ApiModelProperty("存储方式 [UDC]ITM:STORE_MODE")
    @SysCode(sys = "yst-supp", mod = "STORE_MODE")
    String storeMode;
    String storeModeName;

    /**
     * 保质期管理类型
     */
    @ApiModelProperty("保质期管理类型")
    String storeExpireType;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT")
    private String guaranteePeriodUnit;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 存储条件
     */
    @ApiModelProperty("存储条件")
    String storeCondition;

    /**
     * 温层
     */
    @ApiModelProperty("温层")
    @SysCode(sys = "yst-supp", mod = "TEMP_TYPE")
    String tempType;
    String tempTypeName;

    /**
     * 发运类型
     */
    @ApiModelProperty("发运类型")
    String shipmentType;

    /**
     * 供应商回扣类型
     */
    @ApiModelProperty("供应商回扣类型")
    String rebateType;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    String planType;

    /**
     * 盘点类型 30天/60天
     */
    @ApiModelProperty("盘点类型 30天/60天")
    String takeType;

    /**
     * 仓库属性
     */
    @ApiModelProperty("仓库属性")
    String whProp;

    /**
     * 半成品存储仓位
     */
    @ApiModelProperty("半成品存储仓位")
    String semiStore;

    /**
     * 转换率
     */
    @ApiModelProperty("转换率")
    Float repItemRate;

    /**
     * 默认启用批次
     */
    @ApiModelProperty("默认启用批次")
    Boolean lotFlag;

    /**
     * 默认启用货位
     */
    @ApiModelProperty("默认启用货位")
    Boolean locFlag;

    /**
     * 默认启用序列号
     */
    @ApiModelProperty("默认启用序列号")
    Boolean snFlag;

    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    @SysCode(sys = "yst-supp", mod = "COUNTRY")
    String menuCountry;
    String menuCountryName;

    /**
     * 制造类型 成品/半成品/原料/物料
     */
    @ApiModelProperty("制造类型 成品/半成品/原料/物料")
    String manuType;

    /**
     * 制造商ID
     */
    @ApiModelProperty("制造商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long manuerId;

    /**
     * 制造商名称
     */
    @ApiModelProperty("制造商名称")
    String manuerName;

    /**
     * 供应商物料编码
     */
    @ApiModelProperty("供应商物料编码")
    String suppItemCode;

    /**
     * 标准成本
     */
    @ApiModelProperty("标准成本")
    Float stdCost;

    /**
     * 标准人工
     */
    @ApiModelProperty("标准人工")
    Float stdLabCost;

    /**
     * 标准制费
     */
    @ApiModelProperty("标准制费")
    Float stdProdCost;

    /**
     * 替代属性 1：标准原料；2：替代原料
     */
    @ApiModelProperty("替代属性 1：标准原料；2：替代原料")
    String replaceProp;

    /**
     * 替代原料ID
     */
    @ApiModelProperty("替代原料ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long replaceItemId;

    /**
     * 其它类型1
     */
    @ApiModelProperty("其它类型1")
    String otherType1;

    /**
     * 其它类型2
     */
    @ApiModelProperty("其它类型2")
    String otherType2;

    /**
     * 其它类型3
     */
    @ApiModelProperty("其它类型3")
    String otherType3;

    /**
     * 其它类型4
     */
    @ApiModelProperty("其它类型4")
    String otherType4;

    /**
     * 其它类型5
     */
    @ApiModelProperty("其它类型5")
    String otherType5;

    /**
     * 外部编码
     */
    @ApiModelProperty("外部编码")
    String outerCode;

    /**
     * 接口状态
     */
    @ApiModelProperty("接口状态")
    String intfStatus;

    /**
     * 接口处理时间
     */
    @ApiModelProperty("接口处理时间")
    LocalDateTime intfTime;

    /**
     * 标签
     */
    @ApiModelProperty("标签")
    String tags;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    String es1;

    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    String es2;

    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    String es3;

    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    String es4;

    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    String es5;

    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    String es6;

    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    String es7;

    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    String es8;

    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    String es9;

    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    String es10;

    /**
     * ES11
     */
    @ApiModelProperty("ES11")
    String es11;

    /**
     * ES12
     */
    @ApiModelProperty("ES12")
    String es12;

    /**
     * ES13
     */
    @ApiModelProperty("ES13")
    String es13;

    /**
     * ES14
     */
    @ApiModelProperty("ES14")
    String es14;

    /**
     * ES15
     */
    @ApiModelProperty("ES15")
    String es15;

    /**
     * ES16
     */
    @ApiModelProperty("ES16")
    String es16;

    /**
     * ES17
     */
    @ApiModelProperty("ES17")
    String es17;

    /**
     * ES18
     */
    @ApiModelProperty("ES18")
    String es18;

    /**
     * ES19
     */
    @ApiModelProperty("ES19")
    String es19;

    /**
     * ES20
     */
    @ApiModelProperty("ES20")
    String es20;

    /**
     * EN1
     */
    @ApiModelProperty("EN1")
    Float en1;

    /**
     * EN2
     */
    @ApiModelProperty("EN2")
    Float en2;

    /**
     * EN3
     */
    @ApiModelProperty("EN3")
    Float en3;

    /**
     * EN4
     */
    @ApiModelProperty("EN4")
    Float en4;

    /**
     * EN5
     */
    @ApiModelProperty("EN5")
    Float en5;

    /**
     * ED1
     */
    @ApiModelProperty("ED1")
    LocalDateTime ed1;

    /**
     * ED2
     */
    @ApiModelProperty("ED2")
    LocalDateTime ed2;

    /**
     * ED3
     */
    @ApiModelProperty("ED3")
    LocalDateTime ed3;

    @ApiModelProperty
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    /**
     * 申请人公司id
     */
    @ApiModelProperty("申请人公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouCode;

    /**
     * 申请人公司
     */
    @ApiModelProperty("申请人公司")
    private String ouName2;

    /**
     * 申请部门编码
     */
    @ApiModelProperty("申请部门编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buCode;

    /**
     * 申请部门
     */
    @ApiModelProperty("申请部门")
    private String buName;

}
