package com.elitesland.support.provider.item.param;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品新增参数
 *
 * @author chun.yan
 * @date 2022-05-30
 */
@Data
@ApiModel("商品查询参数")
public class ItmItemQueryParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 3960580113867575891L;

    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 商品编号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    /**
     * 商品编号2
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "商品编号2")
    private String itemCode2;

    /**
     * 商品编号3
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "商品编号3")
    private String itemCode3;

    /**
     * 商品名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * SPU_ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "SPU_ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    /**
     * SPU_CODE
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "SPU_CODE")
    private String spuCode;

    /**
     * SPU_CODE
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "SPU_NAME")
    private String spuName;

    /**
     * 标准
     */
    @ApiModelProperty(value = "标准")
    private String standard;

    /**
     * 标准
     */
    @ApiModelProperty(value = "标准")
    private String standardDesc;

    /**
     * 材质
     */
    @ApiModelProperty(value = "材质")
    private String material;

    /**
     * 材质
     */
    @ApiModelProperty(value = "材质")
    private String materialDesc;

    /**
     * 直径
     */
    @ApiModelProperty(value = "直径")
    private String diameter;

    /**
     * 直径
     */
    @ApiModelProperty(value = "直径")
    private String diameterDesc;

    /**
     * 长度
     */
    @ApiModelProperty(value = "长度")
    private String lengths;

    /**
     * 长度
     */
    @ApiModelProperty(value = "长度")
    private String lengthsDesc;

    /**
     * 牙别
     */
    @ApiModelProperty(value = "牙别")
    private String tooth;

    /**
     * 牙别
     */
    @ApiModelProperty(value = "牙别")
    private String toothDesc;

    /**
     * 表面处理
     */
    @ApiModelProperty(value = "表面处理")
    private String surface;

    /**
     * 表面处理
     */
    @ApiModelProperty(value = "表面处理")
    private String surfaceDesc;

    /**
     * 强度
     */
    @ApiModelProperty(value = "强度")
    private String strength;

    /**
     * 强度
     */
    @ApiModelProperty(value = "强度")
    private String strengthDesc;

    /**
     * 来源
     */
    @ApiModelProperty(value = "来源")
    private String source;

    /**
     * 产品分类
     */
    @ApiModelProperty(value = "产品分类")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    /**
     * 规格
     */
    @ApiModelProperty(value = "规格")
    private String spec;

    /**
     * 商品状态
     */
    @ApiModelProperty(value = "商品状态 TO_BE_AUDITED:待审核，AUDITED:已审核")
    private String itemStatus2;

    @ApiModelProperty(value = "等级")
    private String itemLevel;

    @ApiModelProperty(value = "等级描述")
    private String itemLevelDesc;

    @ApiModelProperty(value = "组合垫圈类型")
    private String washerType;

    @ApiModelProperty(value = "组合垫圈类型描述")
    private String washerTypeDesc;

    @ApiModelProperty(value = "种类")
    private String kind;

    @ApiModelProperty(value = "种类描述")
    private String kindDesc;

    @ApiModelProperty(value = "用途")
    private String purpose;

    @ApiModelProperty(value = "用途描述")
    private String purposeDesc;

    @ApiModelProperty(value = "牙长")
    private String toothLength;

    @ApiModelProperty(value = "牙长描述")
    private String toothLengthDesc;

    @ApiModelProperty(value = "牙型")
    private String toothShape;

    @ApiModelProperty(value = "牙型描述")
    private String toothShapeDesc;

    @ApiModelProperty(value = "型状")
    private String shape;

    @ApiModelProperty(value = "型状描述")
    private String shapeDesc;

    @ApiModelProperty(value = "尾状")
    private String caudate;

    @ApiModelProperty(value = "尾状描述")
    private String caudateDesc;

    @ApiModelProperty(value = "外径")
    private String outerDiameter;

    @ApiModelProperty(value = "外径描述")
    private String outerDiameterDesc;

    @ApiModelProperty(value = "头型")
    private String headShape;

    @ApiModelProperty(value = "头型描述")
    private String headShapeDesc;

    @ApiModelProperty(value = "螺纹")
    private String whorl;

    @ApiModelProperty(value = "螺纹描述")
    private String whorlDesc;

    @ApiModelProperty(value = "厚度")
    private String thickness;

    @ApiModelProperty(value = "厚度描述")
    private String thicknessDesc;

    @ApiModelProperty(value = "杆状")
    private String rhabditiform;

    @ApiModelProperty(value = "杆状描述")
    private String rhabditiformDesc;

    @ApiModelProperty(value = "防松处理")
    private String antiLoose;

    @ApiModelProperty(value = "防松处理描述")
    private String antiLooseDesc;

    @ApiModelProperty(value = "尺寸等级")
    private String sizeLevel;

    @ApiModelProperty(value = "尺寸等级描述")
    private String sizeLevelDesc;

    @ApiModelProperty(value = "槽型")
    private String grooveShape;

    @ApiModelProperty(value = "槽型描述")
    private String grooveShapeDesc;

    @ApiModelProperty(value = "内径")
    private String innerDiameter;

    @ApiModelProperty(value = "内径描述")
    private String innerDiameterDesc;

    @ApiModelProperty(value = "加工方式")
    private String processingMethod;

    @ApiModelProperty(value = "加工方式描述")
    private String processingMethodDesc;

    @ApiModelProperty(value = "适用行业")
    private String suitIndustry;

    @ApiModelProperty(value = "适用行业描述")
    private String suitIndustryDesc;

}
