package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/25
 */
@Data
@ApiModel(description = "商品主表提供给供应链分页查询条件")
public class ItmBrandSupplyPagingDTO implements Serializable {
    private static final long serialVersionUID = -7385692011182472783L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品牌id")
    private Long id;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String brandName;

}
