package com.elitesland.support.provider.item.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author yc
 * @date 2022/8/11
 */
@Data
@ApiModel(value = "商品属性查询", description = "商品属性查询")
public class ItmItemAttrParam implements Serializable {

    private static final long serialVersionUID = 6289467720945796757L;

    @ApiModelProperty("分类ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> catId;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> spuId;

    @ApiModelProperty("spuCode")
    private List<String> spuCode;

    @ApiModelProperty("标准")
    private List<String> standard;

    @ApiModelProperty("材质")
    private List<String> material;

    @ApiModelProperty("直径")
    private List<String> diameter;

    @ApiModelProperty("长度")
    private List<String> lengths;

    @ApiModelProperty("牙别")
    private List<String> tooth;

    @ApiModelProperty("表面处理")
    private List<String> surface;

    @ApiModelProperty("强度/印记")
    private List<String> strength;

    @ApiModelProperty(value = "等级")
    private List<String> itemLevel;

    @ApiModelProperty(value = "组合垫圈类型")
    private List<String> washerType;

    @ApiModelProperty(value = "种类")
    private List<String> kind;

    @ApiModelProperty(value = "用途")
    private List<String> purpose;

    @ApiModelProperty(value = "牙长")
    private List<String> toothLength;

    @ApiModelProperty(value = "牙型")
    private List<String> toothShape;

    @ApiModelProperty(value = "型状")
    private List<String> shape;

    @ApiModelProperty(value = "尾状")
    private List<String> caudate;

    @ApiModelProperty(value = "外径")
    private List<String> outerDiameter;

    @ApiModelProperty(value = "头型")
    private List<String> headShape;

    @ApiModelProperty(value = "螺纹")
    private List<String> whorl;

    @ApiModelProperty(value = "厚度")
    private List<String> thickness;

    @ApiModelProperty(value = "杆状")
    private List<String> rhabditiform;

    @ApiModelProperty(value = "防松处理")
    private List<String> antiLoose;

    @ApiModelProperty(value = "尺寸等级")
    private List<String> sizeLevel;

    @ApiModelProperty(value = "槽型")
    private List<String> grooveShape;

    @ApiModelProperty(value = "内径")
    private List<String> innerDiameter;

    @ApiModelProperty(value = "加工方式")
    private List<String> processingMethod;

    @ApiModelProperty(value = "适用行业")
    private List<String> suitIndustry;

    @ApiModelProperty(value = "来源")
    private List<String> source;



}
