package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 功能说明 给前端:demo表
 *
 * @author meng
 * @date 2022-04-12 19:10:59
 */
@Data
@ApiModel(value = " yst_itm_item ", description = "商品表")
public class TmItmItemNRespVO implements Serializable {
    private static final long serialVersionUID = 3276138851048482690L;


    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 品项编号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品项编号")
    private String itemCode;

    /**
     * 第二编号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "第二编号")
    private String itemCode2;

    @ApiModelProperty("重量")
    private BigDecimal netWeight;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty(value = "分散打散标记：1是，0否")
    private Boolean tagItm;


}
