package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 功能说明 给前端:demo表
 *
 * @author meng
 * @date 2022-04-12 08:37:56
 */
@Data
@ApiModel(value = " yst_item_proportion ", description = "供应商和商品比例表")
public class YstItemProportionDTO implements Serializable {
    private static final long serialVersionUID = 9008647388728255064L;

    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty(value = "A可超量,B可欠量")
    private String lessNumber;


    @ApiModelProperty(value = "欠量比例")
    private BigDecimal  lessProportion;

    /**
     * 供应商ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 品项ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "超量比例")
    private BigDecimal  moreProportion;

    @ApiModelProperty("采购比例")
    private BigDecimal itemProportion;

}
