package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 功能说明 给前端:供应商和品类之间关系表表
 *
 * @author meng
 * @date 2022-03-19 09:12:01
 */
@Data
@ApiModel(value = " yst_supp_c13 ", description = "供应商和品类关系表")
public class YstSuppC13DTO implements Serializable {
    private static final long serialVersionUID = 1891772319776841963L;

    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 供应商ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    @ApiModelProperty("供应商编码")
    private String suppCode;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;


}
