package com.elitesland.support.provider.item.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2022/11/15
 */
@ApiModel("物料查询参数")
@Data
public class CommonItmItemParamVO implements Serializable {

    private static final long serialVersionUID = -6408566898567244173L;

    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品ID集合")
    private List<Long> itemIds;

    private String itemCode;

    @ApiModelProperty("商品编号集合")
    private List<String> itemCodes;

    private String itemCode2;

    @ApiModelProperty("商品编号2集合")
    private List<String> itemCode2s;

}
