package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-28
 */
@Data
@ApiModel("地址薄-地址信息DTO查询参数")
public class OrgAddressRpcDtoParam implements Serializable {

    private static final long serialVersionUID = 6668767482549077384L;

    /**
     * id 列表
     */
    @ApiModelProperty("id 列表")
    private List<Long> ids;

    /**
     * 地址号列表
     */
    @ApiModelProperty("地址号列表")
    private List<Long> addrNos;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    private String addressType;

    /**
     * 是否默认：true是，false否
     */
    @ApiModelProperty("是否默认：true是，false否")
    private Boolean defaultFlag;

    /**
     * 联系人姓名，支持模糊查询
     */
    @ApiModelProperty("联系人姓名，支持模糊查询")
    private String contPerson;

    /**
     * 手机号码，支持模糊查询
     */
    @ApiModelProperty("手机号码，支持模糊查询")
    private String mobile;

    /**
     * 电话，支持模糊查询
     */
    @ApiModelProperty("电话，支持模糊查询")
    private String tel;

    /**
     * es1
     */
    @ApiModelProperty("es1")
    private String es1;

    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;

    /**
     * es4
     */
    @ApiModelProperty("es4")
    private String es4;

    /**
     * es5
     */
    @ApiModelProperty("es5")
    private String es5;

    /**
     * 代理权权限
     */
    @ApiModelProperty("代理权权限")
    private String es6;

    /**
     * es7
     */
    @ApiModelProperty("es7")
    private String es7;

    /**
     * es8
     */
    @ApiModelProperty("es8")
    private String es8;

    /**
     * es9
     */
    @ApiModelProperty("es9")
    private String es9;

    /**
     * es10
     */
    @ApiModelProperty("es10")
    private String es10;

    /**
     * buid
     */
    @ApiModelProperty("buid")
    private Long buId;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private List<String> dataSources;
}
