package com.elitesland.support.provider.item.param;

import com.elitesland.support.provider.item.dto.ItmItemPicDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 商品新增参数
 *
 * @author chun.yan
 * @date 2022-05-30
 */
@Data
@ApiModel(value =" itm_item "  , description = "商品")
public class ItmItemSaveParam implements Serializable{
private static final long serialVersionUID =3960580113867575891L;

	/**
	 * 记录唯一ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	/**
	 * sec_bu_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_bu_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secBuId;

	/**
	 * sec_user_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_user_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secUserId;

	/**
	 * sec_ou_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_ou_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secOuId;

	/**
	 * 公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long ouId;

	/**
	 * 公司编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司编号")
	private String ouCode;

	/**
	 * 公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司名称")
	private String ouName;

	/**
	 * BU ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "BU ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long buId;

	/**
	 * BU编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "BU编号")
	private String buCode;

	/**
	 * BU名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "BU名称")
	private String buName;

	/**
	 * 商品编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品编号")
	private String itemCode;

	/**
	 * 商品编号2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品编号2")
	private String itemCode2;

	/**
	 * 商品编号3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品编号3")
	private String itemCode3;

	/**
	 * 商品名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品名称")
	private String itemName;

	/**
	 * 商品名称2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品名称2")
	private String itemName2;

	/**
	 * 商品名称3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品名称3")
	private String itemName3;

	/**
	 * 商品简称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品简称")
	private String itemAbbr;

	/**
	 * 商品类型 [UDC]ITM:ITEM_TYPE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品类型 [UDC]ITM:ITEM_TYPE")
	private String itemType;

	/**
	 * 商品类型2 [UDC]ITM:ITEM_TYPE2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品类型2 [UDC]ITM:ITEM_TYPE2")
	private String itemType2;

	/**
	 * 商品类型3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品类型3")
	private String itemType3;

	/**
	 * 商品类型4
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品类型4")
	private String itemType4;

	/**
	 * 商品类型5
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品类型5")
	private String itemType5;

	/**
	 * 商品状态 [UDC]ITM:ITEM_STATUS
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品状态 [UDC]ITM:ITEM_STATUS")
	private String itemStatus;

	/**
	 * 商品状态2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品状态2")
	private String itemStatus2;

	/**
	 * 商品状态3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品状态3")
	private String itemStatus3;

	/**
	 * 规格，比如：食品净含量
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "规格，比如：食品净含量")
	private String spec;

	/**
	 * SPU_ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long spuId;

	/**
	 * SPU_CODE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_CODE")
	private String spuCode;

	/**
	 * SPU_CODE2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_CODE2")
	private String spuCode2;

	/**
	 * SPU_CODE3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_CODE3")
	private String spuCode3;

	/**
	 * SPU_NAME
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_NAME")
	private String spuName;

	/**
	 * SPU_NAME2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_NAME2")
	private String spuName2;

	/**
	 * SPU_NAME3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU_NAME3")
	private String spuName3;

	/**
	 * SPU简称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "SPU简称")
	private String spuAbbr;

	/**
	 * 商品规格
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品规格")
	private String itemAttr;

	/**
	 * 商品规格2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品规格2")
	private String itemAttr2;

	/**
	 * 商品规格3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品规格3")
	private String itemAttr3;

	/**
	 * 商品规格4
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品规格4")
	private String itemAttr4;

	/**
	 * 商品规格5
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品规格5")
	private String itemAttr5;

	/**
	 * 商品品类编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品品类编号")
	private String itemCateCode;

	/**
	 * 商品品类编号2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品品类编号2")
	private String itemCateCode2;

	/**
	 * 商品品类编号3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品品类编号3")
	private String itemCateCode3;

	/**
	 * 商品识别号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品识别号")
	private String itemSource;

	/**
	 * 品牌
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "品牌")
	private String brand;

	/**
	 * 品牌2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "品牌2")
	private String brand2;

	/**
	 * 是否允许自采
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否允许自采")
	private Boolean salepurcFlag;

	/**
	 * 是否启用序列号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否启用序列号")
	private Boolean snFlag;

	/**
	 * 是否启用批次号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否启用批次号")
	private Boolean lotFlag;

	/**
	 * 效期管理标识
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "效期管理标识")
	private Boolean guaranteeFlag;

	/**
	 * 是否享会员折扣
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否享会员折扣")
	private Integer memberdiscFlagx;

	/**
	 * 是否分销
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否分销")
	private Integer distributionFlagx;

	/**
	 * 财务分类 [UDC]ITM:FIN_TYPE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "财务分类 [UDC]ITM:FIN_TYPE")
	private String finType;

	/**
	 * 成本计价方法 [UDC]ITM:COST_TYPE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "成本计价方法 [UDC]ITM:COST_TYPE")
	private String costType;

	/**
	 * 配货类型 [UDC]ITM:ALLOC_TYPE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "配货类型 [UDC]ITM:ALLOC_TYPE")
	private String allocType;

	/**
	 * 配送类型 [UDC]ITM:DELIVER_TYPE
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "配送类型 [UDC]ITM:DELIVER_TYPE")
	private String deliverType;

	/**
	 * 是否需要安装
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否需要安装")
	private Boolean installFlag;

	/**
	 * 是否可退换货
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否可退换货")
	private Boolean returnExchangeFlag;

	/**
	 * 退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY")
	private String returnExchangePolicy;

	/**
	 * 是否保修
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否保修")
	private Boolean warrantyFlag;

	/**
	 * 保修期时长
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "保修期时长")
	private Integer warrantyPeriod;

	/**
	 * 保修期单位 [UDC]COM:TIME_UNIT
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "保修期单位 [UDC]COM:TIME_UNIT")
	private String warrantyPeriodUnit;

	/**
	 * 运输条件
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "运输条件")
	private String transCondition;

	/**
	 * 存储条件
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "存储条件")
	private String storeCondition;

	/**
	 * 包装规格
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "包装规格")
	private String packageSpec;

	/**
	 * 保质期时长
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "保质期时长")
	private Integer guaranteePeriod;

	/**
	 * 保质期单位 [UDC]COM:TIME_UNIT
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "保质期单位 [UDC]COM:TIME_UNIT")
	private String guaranteePeriodUnit;

	/**
	 * 保质期天数
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "保质期天数")
	private Integer guaranteeDays;

	/**
	 * 税收分类码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税收分类码")
	private String taxType;

	/**
	 * 税码(进项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税码(进项)")
	private String taxCode;

	/**
	 * 税率(进项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税率(进项)")
	private Double taxRate;

	/**
	 * 税率编号(进项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税率编号(进项)")
	private String taxRateNo;

	/**
	 * 税码2(销项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税码2(销项)")
	private String taxCode2;

	/**
	 * 税率2(销项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税率2(销项)")
	private Double taxRate2;

	/**
	 * 税率编号2(销项)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税率编号2(销项)")
	private String taxRateNo2;

	/**
	 * 关税税率
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "关税税率")
	private Double taxRateTariff;

	/**
	 * 供应商ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long suppId;

	/**
	 * 供应商编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商编号")
	private String suppCode;

	/**
	 * 供应商简称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商简称")
	private String suppAbbr;

	/**
	 * 供应商名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商名称")
	private String suppName;

	/**
	 * 供应商物料编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商物料编码")
	private String suppItemCode;

	/**
	 * 条码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "条码")
	private String barCode;

	/**
	 * 条码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "条码")
	private String barCode2;

	/**
	 * 主计量单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主计量单位 [UDC]COM:UOM")
	private String uom;

	/**
	 * 主计量单位2 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主计量单位2 [UDC]COM:UOM")
	private String uom2;

	/**
	 * 主计量单位3 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主计量单位3 [UDC]COM:UOM")
	private String uom3;

	/**
	 * 主计量单位4 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主计量单位4 [UDC]COM:UOM")
	private String uom4;

	/**
	 * 主计量单位5 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主计量单位5 [UDC]COM:UOM")
	private String uom5;

	/**
	 * 默认销售单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "默认销售单位 [UDC]COM:UOM")
	private String saleUom;

	/**
	 * 默认采购单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "默认采购单位 [UDC]COM:UOM")
	private String purcUom;

	/**
	 * 发运计量单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发运计量单位 [UDC]COM:UOM")
	private String shipUom;

	/**
	 * 要货计量单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "要货计量单位 [UDC]COM:UOM")
	private String orderUom;

	/**
	 * 定价计量单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "定价计量单位 [UDC]COM:UOM")
	private String pricingUom;

	/**
	 * 库存计量单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "库存计量单位 [UDC]COM:UOM")
	private String storeUom;

	/**
	 * 毛重
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "毛重")
	private Double grossWeight;

	/**
	 * 净重
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "净重")
	private Double netWeight;

	/**
	 * 重量单位 [UDC]COM:WEIGHT_UNIT
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "重量单位 [UDC]COM:WEIGHT_UNIT")
	private String weightUnit;

	/**
	 * 重量对应的品项单位 [UDC]COM:UOM
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "重量对应的品项单位 [UDC]COM:UOM")
	private String weightItemUom;

	/**
	 * 体积
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "体积")
	private Double volume;

	/**
	 * 体积单位 [UDC]COM:VOLUME_UNIT
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "体积单位 [UDC]COM:VOLUME_UNIT")
	private String volumeUnit;

	/**
	 * 长
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "长")
	private Double length;

	/**
	 * 宽
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "宽")
	private Double width;

	/**
	 * 高
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "高")
	private Double height;

	/**
	 * 长度单位 [UDC]COM:LENGTH_UNIT
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "长度单位 [UDC]COM:LENGTH_UNIT")
	private String lengthUnit;

	/**
	 * 最小起定量
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "最小起定量")
	private Double moq;

	/**
	 * 安全库存
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "安全库存")
	private Double safeQty;

	/**
	 * 最大要货量
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "最大要货量")
	private Double maxOrderQty;

	/**
	 * 标签
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "标签")
	private String tags;

	/**
	 * 外部编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部编号")
	private String outerCode;

	/**
	 * 外部编号2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部编号2")
	private String outerCode2;

	/**
	 * 是否第三方入驻商品 0：否  1：是  ，默认0
	 * nullable : true
	 * default  : '0'
	 */
	@ApiModelProperty(value = "是否第三方入驻商品 0：否  1：是  ，默认0")
	private String cat;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT2
	 * nullable : true
	 * default  : '0'
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT2")
	private String cat2;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT3")
	private String cat3;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT4
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT4")
	private String cat4;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT5
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT5")
	private String cat5;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT6
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT6")
	private String cat6;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT7
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT7")
	private String cat7;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT8
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT8")
	private String cat8;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT9
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT9")
	private String cat9;

	/**
	 * 类别码 [UDC]ITM:ITM_CAT10
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "类别码 [UDC]ITM:ITM_CAT10")
	private String cat10;

	/**
	 * ES1
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES1")
	private String es1;

	/**
	 * ES2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES2")
	private String es2;

	/**
	 * ES3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES3")
	private String es3;

	/**
	 * ES4
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES4")
	private String es4;

	/**
	 * ES5
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES5")
	private String es5;

	/**
	 * ES6
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES6")
	private String es6;

	/**
	 * ES7
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES7")
	private String es7;

	/**
	 * ES8
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES8")
	private String es8;

	/**
	 * ES9
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES9")
	private String es9;

	/**
	 * ES10
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ES10")
	private String es10;

	/**
	 * EN1
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "EN1")
	private Double en1;

	/**
	 * EN2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "EN2")
	private Double en2;

	/**
	 * EN3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "EN3")
	private Double en3;

	/**
	 * EN4
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "EN4")
	private Double en4;

	/**
	 * EN5
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "EN5")
	private Double en5;

	/**
	 * ED1
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ED1")
	private LocalDateTime ed1;

	/**
	 * ED2
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ED2")
	private LocalDateTime ed2;

	/**
	 * ED3
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ED3")
	private LocalDateTime ed3;

	/**
	 * 租户ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long tenantId;

	/**
	 * 备注
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/**
	 * 记录创建者ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long createUserId;

	/**
	 * 记录创建者
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建者")
	private String creator;

	/**
	 * 记录创建时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	/**
	 * 记录最后更新者ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long modifyUserId;

	/**
	 * 记录最后更新者
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	/**
	 * 记录最后更新时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	/**
	 * 逻辑删除，0：未删除，1：已删除
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
	private Integer deleteFlag;

	/**
	 * 锁版本
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "锁版本")
	private Integer auditDataVersion;

	/**
	 * 是否发布
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否发布")
	private Boolean releaseFlag;

	/**
	 * 是否需要售后服务
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否需要售后服务")
	private Boolean aftersalesServiceFlagx;

	/**
	 * 标准
	 */
	@ApiModelProperty(value = "标准")
	private String standard;

	/**
	 * 标准描述
	 */
	@ApiModelProperty(value = "标准描述")
	private String standardDesc;

	/**
	 * 标准排序
	 */
	@ApiModelProperty(value = "标准排序")
	private Integer standardSort;

	/**
	 * 材质
	 */
	@ApiModelProperty(value = "材质")
	private String material;

	/**
	 * 材质描述
	 */
	@ApiModelProperty(value = "材质描述")
	private String materialDesc;

	/**
	 * 材质排序
	 */
	@ApiModelProperty(value = "材质排序")
	private Integer materialSort;

	/**
	 * 直径
	 */
	@ApiModelProperty(value = "直径")
	private String diameter;

	/**
	 * 直径描述
	 */
	@ApiModelProperty(value = "直径描述")
	private String diameterDesc;

	/**
	 * 直径排序
	 */
	@ApiModelProperty(value = "直径排序")
	private Integer diameterSort;

	/**
	 * 长度
	 */
	@ApiModelProperty(value = "长度")
	private String lengths;

	/**
	 * 长度描述
	 */
	@ApiModelProperty(value = "长度描述")
	private String lengthsDesc;

	/**
	 * 长度排序
	 */
	@ApiModelProperty(value = "长度排序")
	private Integer lengthsSort;

	/**
	 * 牙别
	 */
	@ApiModelProperty(value = "牙别")
	private String tooth;

	/**
	 * 牙别描述
	 */
	@ApiModelProperty(value = "牙别描述")
	private String toothDesc;

	/**
	 * 牙别排序
	 */
	@ApiModelProperty(value = "牙别排序")
	private Integer toothSort;

	/**
	 * 表面处理
	 */
	@ApiModelProperty(value = "表面处理")
	private String surface;

	/**
	 * 表面处理描述
	 */
	@ApiModelProperty(value = "表面处理描述")
	private String surfaceDesc;

	/**
	 * 表面处理排序
	 */
	@ApiModelProperty(value = "表面处理排序")
	private Integer surfaceSort;

	@ApiModelProperty(value = "强度印记")
	private String strength;

	@ApiModelProperty(value = "强度印记描述")
	private String strengthDesc;

	@ApiModelProperty(value = "强度印记排序")
	private Integer strengthSort;

	/**
	 * 来源
	 */
	@ApiModelProperty(value = "来源")
	private String source;

	/**
	 * 图片列表
	 */
	@ApiModelProperty("图片列表")
	private List<ItmItemPicDTO> itemPicList;

	@ApiModelProperty(value = "等级")
	private String itemLevel;

	@ApiModelProperty(value = "等级描述")
	private String itemLevelDesc;

	@ApiModelProperty(value = "等级排序")
	private Integer itemLevelSort;

	@ApiModelProperty(value = "组合垫圈类型")
	private String washerType;

	@ApiModelProperty(value = "组合垫圈类型描述")
	private String washerTypeDesc;

	@ApiModelProperty(value = "组合垫圈类型排序")
	private Integer washerTypeSort;

	@ApiModelProperty(value = "种类")
	private String kind;

	@ApiModelProperty(value = "种类描述")
	private String kindDesc;

	@ApiModelProperty(value = "种类排序")
	private Integer kindSort;

	@ApiModelProperty(value = "用途")
	private String purpose;

	@ApiModelProperty(value = "用途描述")
	private String purposeDesc;

	@ApiModelProperty(value = "用途排序")
	private Integer purposeSort;

	@ApiModelProperty(value = "牙长")
	private String toothLength;

	@ApiModelProperty(value = "牙长描述")
	private String toothLengthDesc;

	@ApiModelProperty(value = "牙长排序")
	private Integer toothLengthSort;

	@ApiModelProperty(value = "牙型")
	private String toothShape;

	@ApiModelProperty(value = "牙型描述")
	private String toothShapeDesc;

	@ApiModelProperty(value = "牙型排序")
	private Integer toothShapeSort;

	@ApiModelProperty(value = "型状")
	private String shape;

	@ApiModelProperty(value = "型状描述")
	private String shapeDesc;

	@ApiModelProperty(value = "型状排序")
	private Integer shapeSort;

	@ApiModelProperty(value = "尾状")
	private String caudate;

	@ApiModelProperty(value = "尾状描述")
	private String caudateDesc;

	@ApiModelProperty(value = "尾状排序")
	private Integer caudateSort;

	@ApiModelProperty(value = "外径")
	private String outerDiameter;

	@ApiModelProperty(value = "外径描述")
	private String outerDiameterDesc;

	@ApiModelProperty(value = "外径排序")
	private Integer outerDiameterSort;

	@ApiModelProperty(value = "头型")
	private String headShape;

	@ApiModelProperty(value = "头型描述")
	private String headShapeDesc;

	@ApiModelProperty(value = "头型排序")
	private Integer headShapeSort;

	@ApiModelProperty(value = "螺纹")
	private String whorl;

	@ApiModelProperty(value = "螺纹描述")
	private String whorlDesc;

	@ApiModelProperty(value = "螺纹排序")
	private Integer whorlSort;

	@ApiModelProperty(value = "厚度")
	private String thickness;

	@ApiModelProperty(value = "厚度描述")
	private String thicknessDesc;

	@ApiModelProperty(value = "厚度排序")
	private Integer thicknessSort;

	@ApiModelProperty(value = "杆状")
	private String rhabditiform;

	@ApiModelProperty(value = "杆状描述")
	private String rhabditiformDesc;

	@ApiModelProperty(value = "杆状排序")
	private Integer rhabditiformSort;

	@ApiModelProperty(value = "防松处理")
	private String antiLoose;

	@ApiModelProperty(value = "防松处理描述")
	private String antiLooseDesc;

	@ApiModelProperty(value = "防松处理排序")
	private Integer antiLooseSort;

	@ApiModelProperty(value = "尺寸等级")
	private String sizeLevel;

	@ApiModelProperty(value = "尺寸等级描述")
	private String sizeLevelDesc;

	@ApiModelProperty(value = "尺寸等级排序")
	private Integer sizeLevelSort;

	@ApiModelProperty(value = "槽型")
	private String grooveShape;

	@ApiModelProperty(value = "槽型描述")
	private String grooveShapeDesc;

	@ApiModelProperty(value = "槽型排序")
	private Integer grooveShapeSort;

	@ApiModelProperty(value = "内径")
	private String innerDiameter;

	@ApiModelProperty(value = "内径描述")
	private String innerDiameterDesc;

	@ApiModelProperty(value = "内径排序")
	private Integer innerDiameterSort;

	@ApiModelProperty(value = "加工方式")
	private String processingMethod;

	@ApiModelProperty(value = "加工方式描述")
	private String processingMethodDesc;

	@ApiModelProperty(value = "加工方式排序")
	private Integer processingMethodSort;

	@ApiModelProperty(value = "适用行业")
	private String suitIndustry;

	@ApiModelProperty(value = "适用行业描述")
	private String suitIndustryDesc;

	@ApiModelProperty(value = "适用行业排序")
	private Integer suitIndustrySort;
}
