package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-04-06
 */
@Data
public class ItmItemCateDetailsDTO implements Serializable {

    private static final long serialVersionUID = 1826351979206214588L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "父级ID")
    private Long pid;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 科目级别
     */
    @ApiModelProperty(value = "科目级别")
    private Integer level;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 上级品类路径名称
     */
    @ApiModelProperty(value = "上级品类路径名称（父级>子级）")
    private String itemCatePathName;

    /**
     * 是否基础类目（0：不是，1：是）
     */
    @ApiModelProperty(value = "是否基础类目（0：不是，1：是）")
    private Integer itemCateIsBasic;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 品类描述
     */
    @ApiModelProperty(value = "品类描述")
    private String itemCateDesc;
}
