package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author : chun.yan
 * @Date : 2022-06-02
 */
@Data
@ApiModel("商品图片DTO")
public class ItmItemPicDTO implements Serializable {

    private static final long serialVersionUID = 1704537404852184527L;
    /**
     * 商品ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 图片名称
     */
    @ApiModelProperty(value = "图片名称")
    private String fileName;

    /**
     * 图片fileCode
     */
    @ApiModelProperty(value = "图片fileCode")
    private String fileCode;

    /**
     * 是否是主图
     */
    @ApiModelProperty(value = "是否是主图")
    private Boolean major;

    /**
     * 图片url
     */
    @ApiModelProperty(value = "图片url")
    private String url;


}
