package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 功能说明 给前端:互斥 中心
 *
 * @author meng
 * @date 2022-08-08 15:13:30
 */
@Data
@ApiModel(value =" yst_serviceset_d "  , description = "比例明细")
public class YstServicesetDRespDTO implements Serializable{
private static final long serialVersionUID =7939256431507539073L;

	/**
	 * 记录唯一ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	/**
	 * 租户ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long tenantId;

	/**
	 * 备注
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/**
	 * 记录创建者ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long createUserId;

	/**
	 * 记录创建者
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建者")
	private String creator;

	/**
	 * 记录创建时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	/**
	 * 记录最后更新者ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long modifyUserId;

	/**
	 * 记录最后更新者
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	/**
	 * 记录最后更新时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	/**
	 * 逻辑删除，0：未删除，1：已删除
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
	private Integer deleteFlag;

	/**
	 * 公司id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long ouId;

	/**
	 * 锁版本
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "锁版本")
	private Integer auditDataVersion;

	/**
	 * sec_bu_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_bu_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secBuId;

	/**
	 * sec_user_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_user_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secUserId;

	/**
	 * sec_ou_id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "sec_ou_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long secOuId;

	/**
	 * 明细code
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "明细code")
	private String masCode;

	/**
	 * 明细id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "明细id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long masId;

	/**
	 * 功能
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "功能")
	private String function;

	/**
	 * 功能udc
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "功能udc")
	private String functionudc;

	/**
	 * 功能设置值
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "功能设置值")
	private String functionvalue;

	/**
	 * 功能值描述
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "功能值描述")
	private String functiondesc;

	@ApiModelProperty(value = "默认")
	private Boolean isDefault;

	@ApiModelProperty(value = "月")
	private String months;

	@ApiModelProperty(value = "日")
	private String days;

	@ApiModelProperty(value = "分值")
	private String score;

	@ApiModelProperty("操作时间")
	private LocalDateTime operationTime;
	@ApiModelProperty("比例")
	private BigDecimal proportion;

}
