package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 公司工厂表
 *
 * @author chaofeng.xia
 * @date 2024/5/31 16:21
 */
@Data
public class OrgOuFactoryRpcDTO implements Serializable {

    private static final long serialVersionUID = 2849016652981727947L;

    private Long id;
    private Long tenantId;
    private Long belongOrgId;

    private Long tenantOrgId;
    private String remark;

    private Long createUserId;
    private String creator;
    private LocalDateTime createTime;

    private Long modifyUserId;

    private String updater;

    private LocalDateTime modifyTime;
    private Integer auditDataVersion;

    private Long secBuId;
    private Long secUserId;

    private Long secOuId;

    /**
     * 公司ID
     */
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 工厂编码
     */
    @ApiModelProperty(value = "工厂编码")
    private String factoryCode;

    /**
     * 工厂名称
     */
    @ApiModelProperty(value = "工厂名称")
    private String factoryName;

    /**
     * 是否质检 0：否 1：是
     */
    @ApiModelProperty(value = "是否质检 0：否 1：是")
    private Boolean qualityFlag;

    /**
     * 存储条件 [UDC]SUPP:STORE_CONDITION
     */
    @ApiModelProperty(value = "存储条件 [UDC]SUPP:STORE_CONDITION")
    private String storeCondition;
    private List<String> storeConditions;

    /**
     * 是否系统内置 0：否 1：是
     */
    @ApiModelProperty(value = "是否系统内置 0：否 1：是")
    private Boolean sysFlag;

    /**
     * 是否启用 0：禁用 1：启用
     */
    @ApiModelProperty(value = "是否启用 0：禁用 1：启用")
    private Boolean enable;
}
