package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrBankAccRpcSaveParam implements Serializable {

    private static final long serialVersionUID = -1281707009056763307L;

    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;


    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String dataSource;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    private String accType;

    @ApiModelProperty(value = "账号编号")
    private String accCode;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 银行ID
     */
    @ApiModelProperty("银行ID")
    private Long bankId;

    /**
     * 银行编号
     */
    @ApiModelProperty("银行编号")
    private String bankCode;

    /**
     * 银行名称
     */
    @ApiModelProperty("银行名称")
    private String bankName;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    private String branchName;

    /**
     * 开户行账号
     */
    @ApiModelProperty("开户行账号")
    private String bankAcc;

    /**
     * 开户人姓名
     */
    @ApiModelProperty("开户人姓名")
    private String holderName;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;


    /**
     * 第三方虚拟用户ID
     */
    @ApiModelProperty(value = "第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;


    /**
     * 第三方虚拟帐户
     */
    @ApiModelProperty(value = "第三方虚拟帐户")
    private String thirdpartyVirtualAcc;

    @ApiModelProperty(value = "银行网点ID")
    private String bankBranchId;
    @ApiModelProperty(value = "银行网点联行号")
    private String bankBranchCode;
    @ApiModelProperty(value = "银行网点名称")
    private String bankBranchName;

    @ApiModelProperty(value = "账号类型, [UDC]SRM:ACCOUNT_TYPE")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty(value = "所有者类型, [UDC]SRM:OWNER_TYPE")
    private String ownerType;
    private String ownerTypeName;

    @ApiModelProperty(value = "银行国际代码")
    private String bankIntelCode;
    @ApiModelProperty(value = "银行地区代码")
    private String bankAreaCode;
}
