package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品spu查询参数
 *
 * @author : chun.yan
 * @Date : 2022-05-31
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ItmItemSpuQueryParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 8384828539761267199L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * SPU编码
     */
    @ApiModelProperty(value = "SPU编码")
    private String spuCode;

    /**
     * SPU名称
     */
    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌")
    private String brand;

    /**
     * 分类ID
     */
    @ApiModelProperty(value = "分类ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    @ApiModelProperty(value = "状态")
    private String spuStatus;


}
