package com.elitesland.support.provider.item.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 功能说明 给前端:demo表
 *
 * @author meng
 * @date 2022-04-12 19:10:59
 */
@Data
@ApiModel(value = " yst_itm_item ", description = "商品表")
public class SrmItmItemNRespVO implements Serializable {
    private static final long serialVersionUID = 3276138851048482690L;


    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 品项编号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品项编号")
    private String itemCode;

    /**
     * 第二编号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "第二编号")
    private String itemCode2;

    /**
     * 项目号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "项目号 ")
    private String itemCode3;


    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 物料类别
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "物料类别")
    private String itemCateCode;
    @ApiModelProperty("商品品类")
    private String itemCateName;

    @ApiModelProperty("商品SKU条码")
    private String barCode;


    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("规格型号")
    private String spec;


    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率
     */
    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    /**
     * 主计量单位
     * nullable : true
     * default  : null
     */
    @ApiModelProperty("主计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 默认采购单位
     */
    @ApiModelProperty("默认采购单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 牙别
     */
    @ApiModelProperty("牙别")
    private String tooth;
    private String toothName;

    /**
     * 材质
     */
    @ApiModelProperty("材质")
    private String material;
    @ApiModelProperty("材质中文")
    private String materialName;

    /**
     * 直径
     */
    @ApiModelProperty("直径")
    private String diameter;
    private String diameterName;

    /**
     * 直径描述
     */
    @ApiModelProperty("直径描述")
    private String diameterDesc;

    /**
     * 标准
     */
    @ApiModelProperty(value = "标准")
    private String standard;

    @ApiModelProperty(value = "印记")
    private String stamp;

    /**
     * 长度
     */
    @ApiModelProperty("长度")
    private String lengths;
    private String lengthsName;

    @ApiModelProperty("说明2")
    private String itemName2;

    @ApiModelProperty("说明3")
    private String itemDesc;


    @ApiModelProperty("供货品类中文")
    private String itemCccName;


    @ApiModelProperty("计量单位2")
    private String uom2;

    @ApiModelProperty("计量单位2中文")
    private String uom2Name;


    @ApiModelProperty("标准中文")
    private String standardName;

    @ApiModelProperty("强度")
    private String strength;

    @ApiModelProperty("强度中文")
    private String strengthName;

    @ApiModelProperty("财务总账类别 JDE总账级")
    private String finGlType;

    @ApiModelProperty("财务总账类别 JDE总账级中文")
    private String finGlTypeName;

    @ApiModelProperty("其它类型1")
    private String otherType1;

    @ApiModelProperty("其它类型1中文")
    private String otherType1Name;

    @ApiModelProperty("其它类型2")
    private String otherType2;

    @ApiModelProperty("其它类型2中文")
    private String otherType2Name;

    @ApiModelProperty("供应商回扣类型")
    private String rebateType;

    @ApiModelProperty("供应商回扣类型中文")
    private String rebateTypeName;

    @ApiModelProperty("计划类型")
    private String planType;

    @ApiModelProperty("计划类型中文")
    private String planTypeName;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightUom;
    private String weightUomName;
    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    String itemType;
    String itemTypeName;

    @ApiModelProperty(value = "发运类型")
    @SysCode(sys = "yst-supp", mod = "SHIPMENT_TYPE")
    private String shipmentType;
    private String shipmentTypeName;


    /**
     * 表面处理
     */
    @ApiModelProperty(value = "表面处理")
    @SysCode(sys = "yst-supp", mod = "SURFACE")
    private String surface;
    private String surfaceName;


    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;


    /**
     * 默认销售单位 [UDC]COM:UOM
     */
    @ApiModelProperty("默认销售单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;
    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    @ApiModelProperty("中类ID")
    private Long c1Id;
    @ApiModelProperty("大类编号")
    private String c1Code;

    @ApiModelProperty("大类名称")
    private String c1Name;

    @ApiModelProperty("中类ID")
    private Long c2Id;

    @ApiModelProperty("中类编号")
    private String c2Code;

    @ApiModelProperty("中类名称")
    private String c2Name;

    @ApiModelProperty("小类ID")
    private Long c3Id;

    @ApiModelProperty("小类编号")
    private String c3Code;

    @ApiModelProperty("小类名称")
    private String c3Name;

    @ApiModelProperty("包装方式")
    private String packageSpec;

    @ApiModelProperty("直径")
    private String es3;

    @ApiModelProperty("长度")
    private String es4;
}
